"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefendInsightsSchema = getDefendInsightsSchema;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _errors = require("../../../errors");
var _incompatible_antivirus = require("./incompatible_antivirus");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefendInsightsSchema({
  type,
  prompts
}) {
  if (type === _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus) {
    return (0, _incompatible_antivirus.getDefendInsightsIncompatibleVirusGenerationSchema)(prompts);
  }
  throw new _errors.InvalidDefendInsightTypeError();
}