"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectWhenSavedObjectNotFound = void 0;
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _branded_loading_indicator = require("./branded_loading_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const RedirectWhenSavedObjectNotFound = ({
  error,
  discoverSessionId
}) => {
  const {
    application: {
      navigateToApp
    },
    core,
    history,
    http: {
      basePath
    },
    toastNotifications,
    urlTracker
  } = (0, _use_discover_services.useDiscoverServices)();
  (0, _useMount.default)(() => {
    const redirect = (0, _public.redirectWhenMissing)({
      history,
      navigateToApp,
      basePath,
      mapping: {
        search: '/',
        'index-pattern': {
          app: 'management',
          path: `kibana/objects/savedSearches/${discoverSessionId}`
        }
      },
      toastNotifications,
      onBeforeRedirect() {
        urlTracker.setTrackedUrl('/');
      },
      ...core
    });
    redirect(error);
  });
  return /*#__PURE__*/_react.default.createElement(_branded_loading_indicator.BrandedLoadingIndicator, null);
};
exports.RedirectWhenSavedObjectNotFound = RedirectWhenSavedObjectNotFound;