"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExistingIndices = useExistingIndices;
var _react = require("react");
var _kibana_context = require("../../../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useExistingIndices() {
  const {
    services: {
      http
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const [indices, setIndices] = (0, _react.useState)([]);
  const [pipelines, setPipelines] = (0, _react.useState)([]);
  const loadIndices = (0, _react.useCallback)(() => {
    http.get('/api/index_management/indices').then(resp => {
      setIndices(resp.filter(i => !(i.hidden || i.frozen)));
    });
  }, [http]);
  const loadPipelines = (0, _react.useCallback)(() => {
    http.get('/api/ingest_pipelines').then(resp => {
      setPipelines(resp.sort((a, b) => a.name.localeCompare(b.name)));
    });
  }, [http]);
  (0, _react.useEffect)(() => {
    loadIndices();
    loadPipelines();
  }, [loadIndices, loadPipelines]);
  const getMapping = (0, _react.useCallback)(async indexName => {
    const resp = await http.get(`/api/index_management/mapping/${indexName}`);
    return resp.mappings;
  }, [http]);
  return {
    indices,
    pipelines,
    getMapping
  };
}