"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromeLayoutComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _application = require("./application");
var _banner = require("./banner");
var _navigation = require("./navigation");
var _footer = require("./footer");
var _header = require("./header");
var _sidebar = require("./sidebar");
var _layout = require("./layout.styles");
var _layout_state_context = require("./layout_state_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The chrome layout component that composes slots together.
 *
 * @param props - ChromeLayoutComponentProps
 * @returns The rendered ChromeLayoutComponent.
 */
const ChromeLayoutComponent = ({
  children,
  ...props
}) => {
  const layoutState = (0, _layout_state_context.useLayoutState)();
  const styles = (0, _layout.useLayoutStyles)(layoutState);
  const renderSlot = slot => {
    if (typeof slot === 'function') {
      return slot(layoutState);
    }
    return slot;
  };
  const banner = layoutState.hasBanner ? /*#__PURE__*/_react.default.createElement(_banner.LayoutBanner, null, renderSlot(props.banner)) : null;
  const footer = layoutState.hasFooter ? /*#__PURE__*/_react.default.createElement(_footer.LayoutFooter, null, renderSlot(props.footer)) : null;
  const navigationPanel = layoutState.hasNavigationPanel ? /*#__PURE__*/_react.default.createElement(_navigation.LayoutNavigationPanel, {
    width: layoutState.navigationPanelWidth
  }, renderSlot(props.navigationPanel)) : null;
  const sidebar = layoutState.hasSidebar ? /*#__PURE__*/_react.default.createElement(_sidebar.LayoutSidebar, null, renderSlot(props.sidebar)) : null;
  const sidebarPanel = layoutState.hasSidebar && layoutState.hasSidebarPanel ? /*#__PURE__*/_react.default.createElement(_sidebar.LayoutSidebarPanel, null, renderSlot(props.sidebarPanel)) : null;
  const header = layoutState.hasHeader ? /*#__PURE__*/_react.default.createElement(_header.LayoutHeader, null, renderSlot(props.header)) : null;
  const navigation = layoutState.hasNavigation ? /*#__PURE__*/_react.default.createElement(_navigation.LayoutNavigation, null, renderSlot(props.navigation)) : null;
  const application = /*#__PURE__*/_react.default.createElement(_application.LayoutApplication, null, renderSlot(children));
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.css,
    style: styles.style
  }, banner, header, navigation, navigationPanel, application, footer, sidebar, sidebarPanel);
};
exports.ChromeLayoutComponent = ChromeLayoutComponent;