"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Create = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateComponent = ({
  customFieldConfiguration,
  isLoading,
  setDefaultValue = true
}) => {
  const {
    key,
    label,
    defaultValue
  } = customFieldConfiguration;
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `customFields.${key}`,
    component: _components.ToggleField,
    config: {
      defaultValue: defaultValue && setDefaultValue ? defaultValue : false
    },
    key: key,
    label: label,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': `${key}-toggle-create-custom-field`,
        disabled: isLoading
      }
    }
  });
};
CreateComponent.displayName = 'Create';
const Create = exports.Create = /*#__PURE__*/_react.default.memo(CreateComponent);