"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("@kbn/aiops-common/constants");
var _dataService = require("@kbn/data-service");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _pattern_analysis_component_wrapper = require("../embeddables/pattern_analysis/pattern_analysis_component_wrapper");
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
var _use_data_source = require("../hooks/use_data_source");
var _use_filters_query = require("../hooks/use_filters_query");
var _use_reload = require("../hooks/use_reload");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Only used to initialize internally
 */

const PatternAnalysisWrapper = ({
  // Component dependencies
  coreStart,
  pluginStart,
  // Component props
  dataViewId,
  timeRange,
  fieldName,
  minimumTimeRangeOption,
  randomSamplerMode,
  randomSamplerProbability,
  onLoading,
  onError,
  onRenderComplete,
  embeddingOrigin,
  lastReloadRequestTime,
  onChange,
  filtersApi
}) => {
  const deps = (0, _react.useMemo)(() => {
    const {
      lens,
      data,
      usageCollection,
      fieldFormats,
      charts,
      share,
      storage,
      unifiedSearch
    } = pluginStart;
    return {
      data,
      lens,
      usageCollection,
      fieldFormats,
      charts,
      share,
      storage,
      unifiedSearch,
      ...coreStart
    };
  }, [coreStart, pluginStart]);
  const datePickerDeps = {
    ...(0, _lodash.pick)(deps, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _dataService.UI_SETTINGS
  };
  const aiopsAppContextValue = (0, _react.useMemo)(() => {
    return {
      embeddingOrigin: embeddingOrigin !== null && embeddingOrigin !== void 0 ? embeddingOrigin : _constants.AIOPS_EMBEDDABLE_ORIGIN.DEFAULT,
      ...deps
    };
  }, [deps, embeddingOrigin]);
  const [manualReload$] = (0, _react.useState)(new _rxjs.BehaviorSubject(lastReloadRequestTime !== null && lastReloadRequestTime !== void 0 ? lastReloadRequestTime : Date.now()));
  (0, _react.useEffect)(function updateManualReloadSubject() {
    if (!lastReloadRequestTime) return;
    manualReload$.next(lastReloadRequestTime);
  }, [lastReloadRequestTime, manualReload$]);
  const resultObservable$ = (0, _react.useMemo)(() => {
    return (0, _rxjs.combineLatest)([manualReload$]).pipe((0, _rxjs.map)(([manualReload]) => Math.max(manualReload)), (0, _rxjs.distinctUntilChanged)());
  }, [manualReload$]);

  // TODO: Remove data-shared-item as part of https://github.com/elastic/kibana/issues/179376>
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-shared-item": "",
    "data-test-subj": "aiopsEmbeddablePatternAnalysis",
    css: {
      width: '100%',
      padding: '10px'
    }
  }, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: aiopsAppContextValue
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: resultObservable$
  }, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViews: pluginStart.data.dataViews,
    dataViewId: dataViewId
  }, /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    timeRange: timeRange,
    filtersApi: filtersApi
  }, /*#__PURE__*/_react.default.createElement(_pattern_analysis_component_wrapper.PatternAnalysisEmbeddableWrapper, {
    dataViewId: dataViewId,
    timeRange: timeRange,
    fieldName: fieldName,
    minimumTimeRangeOption: minimumTimeRangeOption,
    randomSamplerMode: randomSamplerMode,
    randomSamplerProbability: randomSamplerProbability,
    lastReloadRequestTime: lastReloadRequestTime,
    onLoading: onLoading,
    onRenderComplete: onRenderComplete,
    onError: onError,
    onChange: onChange
  })))))));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = PatternAnalysisWrapper;
module.exports = exports.default;