/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

class ResultBuilderForFloat
implements ResultBuilder {
    private final FloatBlock.Builder builder;
    private final boolean inKey;
    private float key;

    ResultBuilderForFloat(BlockFactory blockFactory, TopNEncoder encoder, boolean inKey, int initialSize) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE) : encoder.toString();
        this.inKey = inKey;
        this.builder = blockFactory.newFloatBlockBuilder(initialSize);
    }

    @Override
    public void decodeKey(BytesRef keys) {
        assert (this.inKey);
        this.key = TopNEncoder.DEFAULT_SORTABLE.decodeFloat(keys);
    }

    @Override
    public void decodeValue(BytesRef values) {
        int count = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        switch (count) {
            case 0: {
                this.builder.appendNull();
                break;
            }
            case 1: {
                this.builder.appendFloat(this.inKey ? this.key : this.readValueFromValues(values));
                break;
            }
            default: {
                this.builder.beginPositionEntry();
                for (int i = 0; i < count; ++i) {
                    this.builder.appendFloat(this.readValueFromValues(values));
                }
                this.builder.endPositionEntry();
            }
        }
    }

    private float readValueFromValues(BytesRef values) {
        return TopNEncoder.DEFAULT_UNSORTABLE.decodeFloat(values);
    }

    @Override
    public FloatBlock build() {
        return this.builder.build();
    }

    public String toString() {
        return "ResultBuilderForFloat[inKey=" + this.inKey + "]";
    }

    public void close() {
        this.builder.close();
    }
}

