/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class ProfileHasPrivilegesRequest
extends LegacyActionRequest {
    public static final ConstructingObjectParser<ProfileHasPrivilegesRequest, Void> PARSER = new ConstructingObjectParser("profile_has_privileges_request", false, argv -> new ProfileHasPrivilegesRequest((List)argv[0], (AuthorizationEngine.PrivilegesToCheck)argv[1]));
    private final List<String> uids;
    private final AuthorizationEngine.PrivilegesToCheck privilegesToCheck;

    public ProfileHasPrivilegesRequest(List<String> uids, AuthorizationEngine.PrivilegesToCheck privilegesToCheck) {
        this.uids = Objects.requireNonNull(uids);
        this.privilegesToCheck = Objects.requireNonNull(privilegesToCheck);
    }

    public ProfileHasPrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        this.uids = in.readStringCollectionAsList();
        this.privilegesToCheck = AuthorizationEngine.PrivilegesToCheck.readFrom(in);
    }

    public List<String> profileUids() {
        return this.uids;
    }

    public AuthorizationEngine.PrivilegesToCheck privilegesToCheck() {
        return this.privilegesToCheck;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.uids.isEmpty()) {
            validationException = ValidateActions.addValidationError("profile uids list must not be empty", validationException);
        }
        return this.privilegesToCheck.validate(validationException);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.uids);
        this.privilegesToCheck.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileHasPrivilegesRequest request = (ProfileHasPrivilegesRequest)o;
        return this.uids.equals(request.uids) && this.privilegesToCheck.equals(request.privilegesToCheck);
    }

    public int hashCode() {
        return Objects.hash(this.uids, this.privilegesToCheck);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{uids=" + String.valueOf(this.uids) + ",privileges=" + String.valueOf(this.privilegesToCheck) + "}";
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), Fields.UIDS);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), parser -> RoleDescriptor.parsePrivilegesToCheck("profile_has_privileges_request", false, parser), Fields.PRIVILEGES, ObjectParser.ValueType.OBJECT);
    }

    public static interface Fields {
        public static final ParseField UIDS = new ParseField("uids", new String[0]);
        public static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
    }
}

