/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncResultRequest;
import org.elasticsearch.xpack.core.async.StoredAsyncResponse;

public class AsyncResultsService<Task extends AsyncTask, Response extends AsyncResponse<Response>> {
    private static final Logger logger = LogManager.getLogger(AsyncResultsService.class);
    private final Class<? extends Task> asyncTaskClass;
    private final TaskManager taskManager;
    private final ClusterService clusterService;
    private final AsyncTaskIndexService<Response> store;
    private final boolean updateInitialResultsInStore;
    private final TriFunction<Task, ActionListener<Response>, TimeValue, Boolean> addCompletionListener;

    public AsyncResultsService(AsyncTaskIndexService<Response> store, boolean updateInitialResultsInStore, Class<? extends Task> asyncTaskClass, TriFunction<Task, ActionListener<Response>, TimeValue, Boolean> addCompletionListener, TaskManager taskManager, ClusterService clusterService) {
        this.updateInitialResultsInStore = updateInitialResultsInStore;
        this.asyncTaskClass = asyncTaskClass;
        this.addCompletionListener = addCompletionListener;
        this.taskManager = taskManager;
        this.clusterService = clusterService;
        this.store = store;
    }

    public DiscoveryNode getNode(String id) {
        AsyncExecutionId searchId = AsyncExecutionId.decode(id);
        return this.clusterService.state().nodes().get(searchId.getTaskId().getNodeId());
    }

    public boolean isLocalNode(DiscoveryNode node) {
        return Objects.requireNonNull(node).equals(this.clusterService.localNode());
    }

    public void retrieveResult(GetAsyncResultRequest request, ActionListener<Response> listener) {
        try {
            long nowInMillis = System.currentTimeMillis();
            AsyncExecutionId searchId = AsyncExecutionId.decode(request.getId());
            long expirationTime = request.getKeepAlive() != null && request.getKeepAlive().getMillis() > 0L ? nowInMillis + request.getKeepAlive().getMillis() : -1L;
            if (this.updateInitialResultsInStore & expirationTime > 0L) {
                this.store.updateExpirationTime(searchId.getDocId(), expirationTime, ActionListener.wrap(p -> this.getSearchResponseFromTask(searchId, request, nowInMillis, expirationTime, listener), exc -> {
                    RestStatus status = ExceptionsHelper.status(ExceptionsHelper.unwrapCause(exc));
                    if (status != RestStatus.NOT_FOUND) {
                        logger.error(() -> Strings.format("failed to update expiration time for async-search [%s]", searchId.getEncoded()), (Throwable)exc);
                        listener.onFailure((Exception)exc);
                    } else {
                        listener.onFailure(new ResourceNotFoundException(searchId.getEncoded(), new Object[0]));
                    }
                }));
            } else {
                this.getSearchResponseFromTask(searchId, request, nowInMillis, expirationTime, listener);
            }
        }
        catch (Exception exc2) {
            listener.onFailure(exc2);
        }
    }

    private void getSearchResponseFromTask(AsyncExecutionId searchId, GetAsyncResultRequest request, long nowInMillis, long expirationTimeMillis, ActionListener<Response> listener) {
        try {
            boolean added;
            Task task = this.store.getTaskAndCheckAuthentication(this.taskManager, searchId, this.asyncTaskClass);
            if (task == null || this.updateInitialResultsInStore && task.isCancelled()) {
                this.getSearchResponseFromIndex(searchId, request, nowInMillis, listener);
                return;
            }
            if (expirationTimeMillis != -1L) {
                task.setExpirationTime(expirationTimeMillis);
            }
            if (!(added = this.addCompletionListener.apply(task, listener.delegateFailure((l, response) -> this.sendFinalResponse(request, (Response)response, nowInMillis, (ActionListener<Response>)l)), request.getWaitForCompletionTimeout()).booleanValue())) {
                assert (this.store.getTaskAndCheckAuthentication(this.taskManager, searchId, this.asyncTaskClass) == null);
                this.getSearchResponseFromIndex(searchId, request, nowInMillis, listener);
            }
        }
        catch (Exception exc) {
            listener.onFailure(exc);
        }
    }

    private void getSearchResponseFromIndex(AsyncExecutionId searchId, GetAsyncResultRequest request, long nowInMillis, ActionListener<Response> listener) {
        this.store.getResponse(searchId, true, listener.delegateFailure((l, response) -> {
            try {
                this.sendFinalResponse(request, (Response)response, nowInMillis, (ActionListener<Response>)l);
            }
            finally {
                StoredAsyncResponse storedAsyncResponse;
                Object patt0$temp;
                if (response instanceof StoredAsyncResponse && (patt0$temp = (storedAsyncResponse = (StoredAsyncResponse)response).getResponse()) instanceof RefCounted) {
                    RefCounted refCounted = (RefCounted)patt0$temp;
                    refCounted.decRef();
                }
            }
        }));
    }

    private void sendFinalResponse(GetAsyncResultRequest request, Response response, long nowInMillis, ActionListener<Response> listener) {
        if (response.getExpirationTime() < nowInMillis) {
            listener.onFailure(new ResourceNotFoundException(request.getId(), new Object[0]));
            return;
        }
        listener.onResponse(response);
    }
}

