/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.search.vectors.DiversifyingNearestChildrenKnnCollector;

public class DiversifiedIVFKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    private final BitSetProducer parentsFilter;

    DiversifiedIVFKnnCollectorManager(int k, BitSetProducer parentsFilter) {
        this.k = k;
        this.parentsFilter = parentsFilter;
    }

    @Override
    public KnnCollector newCollector(int visitedLimit, KnnSearchStrategy searchStrategy, LeafReaderContext context) throws IOException {
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return null;
        }
        return new DiversifyingNearestChildrenKnnCollector(this.k, visitedLimit, searchStrategy, parentBitSet);
    }
}

