/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public interface RestRequestFilter {
    default public RestRequest getFilteredRequest(final RestRequest restRequest) {
        final Set<String> fields = this.getFilteredFields();
        if (restRequest.hasContent() && !fields.isEmpty()) {
            return new RestRequest(this, restRequest){
                private BytesReference filteredBytes;
                {
                    super(other);
                    this.filteredBytes = null;
                }

                @Override
                public boolean hasContent() {
                    return true;
                }

                @Override
                public ReleasableBytesReference content() {
                    if (this.filteredBytes == null) {
                        Tuple<XContentType, Map<String, Object>> result = XContentHelper.convertToMap(restRequest.requiredContent(), true, restRequest.getXContentType());
                        Map<String, Object> transformedSource = XContentMapValues.filter(result.v2(), null, fields.toArray(Strings.EMPTY_ARRAY));
                        try {
                            XContentBuilder xContentBuilder = XContentBuilder.builder(result.v1().xContent()).map(transformedSource);
                            this.filteredBytes = BytesReference.bytes(xContentBuilder);
                        }
                        catch (IOException e) {
                            throw new ElasticsearchException("failed to parse request", (Throwable)e, new Object[0]);
                        }
                    }
                    return ReleasableBytesReference.wrap(this.filteredBytes);
                }
            };
        }
        return restRequest;
    }

    public Set<String> getFilteredFields();
}

