/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.support.replication.ReplicationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.Requests;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class IndexRequestBuilder
extends ReplicationRequestBuilder<IndexRequest, DocWriteResponse, IndexRequestBuilder>
implements WriteRequestBuilder<IndexRequestBuilder> {
    private String id = null;
    private BytesReference sourceBytesReference;
    private XContentType sourceContentType;
    private String pipeline;
    private Boolean requireAlias;
    private Boolean requireDataStream;
    private String routing;
    private WriteRequest.RefreshPolicy refreshPolicy;
    private Long ifSeqNo;
    private Long ifPrimaryTerm;
    private DocWriteRequest.OpType opType;
    private Boolean create;
    private Long version;
    private VersionType versionType;

    public IndexRequestBuilder(ElasticsearchClient client) {
        this(client, (String)null);
    }

    public IndexRequestBuilder(ElasticsearchClient client, @Nullable String index) {
        super(client, TransportIndexAction.TYPE);
        this.setIndex(index);
    }

    public IndexRequestBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public IndexRequestBuilder setRouting(String routing) {
        this.routing = routing;
        return this;
    }

    public IndexRequestBuilder setSource(BytesReference source, XContentType xContentType) {
        this.sourceBytesReference = source;
        this.sourceContentType = xContentType;
        return this;
    }

    public IndexRequestBuilder setSource(Map<String, ?> source) {
        return this.setSource(source, Requests.INDEX_CONTENT_TYPE);
    }

    public IndexRequestBuilder setSource(Map<String, ?> source, XContentType contentType) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.setSource(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequestBuilder setSource(String source, XContentType xContentType) {
        this.sourceBytesReference = new BytesArray(source);
        this.sourceContentType = xContentType;
        return this;
    }

    public IndexRequestBuilder setSource(XContentBuilder sourceBuilder) {
        this.sourceBytesReference = BytesReference.bytes(sourceBuilder);
        this.sourceContentType = sourceBuilder.contentType();
        return this;
    }

    public IndexRequestBuilder setSource(byte[] source, XContentType xContentType) {
        return this.setSource(source, 0, source.length, xContentType);
    }

    public IndexRequestBuilder setSource(byte[] source, int offset, int length, XContentType xContentType) {
        this.sourceBytesReference = new BytesArray(source, offset, length);
        this.sourceContentType = xContentType;
        return this;
    }

    public IndexRequestBuilder setSource(Object ... source) {
        return this.setSource(Requests.INDEX_CONTENT_TYPE, source);
    }

    public IndexRequestBuilder setSource(XContentType xContentType, Object ... source) {
        return this.setSource(IndexRequest.getXContentBuilder(xContentType, source));
    }

    public IndexRequestBuilder setOpType(DocWriteRequest.OpType opType) {
        this.opType = opType;
        return this;
    }

    public IndexRequestBuilder setCreate(boolean create) {
        this.create = create;
        return this;
    }

    public IndexRequestBuilder setVersion(long version) {
        this.version = version;
        return this;
    }

    public IndexRequestBuilder setVersionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public IndexRequestBuilder setIfSeqNo(long seqNo) {
        this.ifSeqNo = seqNo;
        return this;
    }

    public IndexRequestBuilder setIfPrimaryTerm(long term) {
        this.ifPrimaryTerm = term;
        return this;
    }

    public IndexRequestBuilder setPipeline(String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public IndexRequestBuilder setRequireAlias(boolean requireAlias) {
        this.requireAlias = requireAlias;
        return this;
    }

    public IndexRequestBuilder setRequireDataStream(boolean requireDataStream) {
        this.requireDataStream = requireDataStream;
        return this;
    }

    @Override
    public IndexRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public IndexRequestBuilder setRefreshPolicy(String refreshPolicy) {
        this.refreshPolicy = WriteRequest.RefreshPolicy.parse(refreshPolicy);
        return this;
    }

    @Override
    public IndexRequest request() {
        IndexRequest request = new IndexRequest();
        super.apply(request);
        request.id(this.id);
        if (this.sourceBytesReference != null && this.sourceContentType != null) {
            request.source(this.sourceBytesReference, this.sourceContentType);
        }
        if (this.pipeline != null) {
            request.setPipeline(this.pipeline);
        }
        if (this.routing != null) {
            request.routing(this.routing);
        }
        if (this.refreshPolicy != null) {
            request.setRefreshPolicy(this.refreshPolicy);
        }
        if (this.ifSeqNo != null) {
            request.setIfSeqNo(this.ifSeqNo);
        }
        if (this.ifPrimaryTerm != null) {
            request.setIfPrimaryTerm(this.ifPrimaryTerm);
        }
        if (this.pipeline != null) {
            request.setPipeline(this.pipeline);
        }
        if (this.requireAlias != null) {
            request.setRequireAlias(this.requireAlias);
        }
        if (this.requireDataStream != null) {
            request.setRequireDataStream(this.requireDataStream);
        }
        if (this.opType != null) {
            request.opType(this.opType);
        }
        if (this.create != null) {
            request.create(this.create);
        }
        if (this.version != null) {
            request.version(this.version);
        }
        if (this.versionType != null) {
            request.versionType(this.versionType);
        }
        return request;
    }
}

