/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Category
implements JsonpSerializable {
    private final Number categoryId;
    private final List<String> examples;
    @Nullable
    private final String grokPattern;
    private final String jobId;
    private final Number maxMatchingLength;
    @Nullable
    private final String partitionFieldName;
    @Nullable
    private final String partitionFieldValue;
    private final String regex;
    private final String terms;
    @Nullable
    private final Long numMatches;
    private final List<String> preferredToCategories;
    @Nullable
    private final String p;
    private final String resultType;
    private final String mlcategory;
    public static final JsonpDeserializer<Category> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Category::setupCategoryDeserializer);

    private Category(Builder builder) {
        this.categoryId = ApiTypeHelper.requireNonNull(builder.categoryId, this, "categoryId");
        this.examples = ApiTypeHelper.unmodifiableRequired(builder.examples, (Object)this, "examples");
        this.grokPattern = builder.grokPattern;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.maxMatchingLength = ApiTypeHelper.requireNonNull(builder.maxMatchingLength, this, "maxMatchingLength");
        this.partitionFieldName = builder.partitionFieldName;
        this.partitionFieldValue = builder.partitionFieldValue;
        this.regex = ApiTypeHelper.requireNonNull(builder.regex, this, "regex");
        this.terms = ApiTypeHelper.requireNonNull(builder.terms, this, "terms");
        this.numMatches = builder.numMatches;
        this.preferredToCategories = ApiTypeHelper.unmodifiable(builder.preferredToCategories);
        this.p = builder.p;
        this.resultType = ApiTypeHelper.requireNonNull(builder.resultType, this, "resultType");
        this.mlcategory = ApiTypeHelper.requireNonNull(builder.mlcategory, this, "mlcategory");
    }

    public static Category of(Function<Builder, ObjectBuilder<Category>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number categoryId() {
        return this.categoryId;
    }

    public final List<String> examples() {
        return this.examples;
    }

    @Nullable
    public final String grokPattern() {
        return this.grokPattern;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Number maxMatchingLength() {
        return this.maxMatchingLength;
    }

    @Nullable
    public final String partitionFieldName() {
        return this.partitionFieldName;
    }

    @Nullable
    public final String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public final String regex() {
        return this.regex;
    }

    public final String terms() {
        return this.terms;
    }

    @Nullable
    public final Long numMatches() {
        return this.numMatches;
    }

    public final List<String> preferredToCategories() {
        return this.preferredToCategories;
    }

    @Nullable
    public final String p() {
        return this.p;
    }

    public final String resultType() {
        return this.resultType;
    }

    public final String mlcategory() {
        return this.mlcategory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("category_id");
        generator.write(this.categoryId.doubleValue());
        if (ApiTypeHelper.isDefined(this.examples)) {
            generator.writeKey("examples");
            generator.writeStartArray();
            for (String item0 : this.examples) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.grokPattern != null) {
            generator.writeKey("grok_pattern");
            generator.write(this.grokPattern);
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("max_matching_length");
        generator.write(this.maxMatchingLength.doubleValue());
        if (this.partitionFieldName != null) {
            generator.writeKey("partition_field_name");
            generator.write(this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            generator.writeKey("partition_field_value");
            generator.write(this.partitionFieldValue);
        }
        generator.writeKey("regex");
        generator.write(this.regex);
        generator.writeKey("terms");
        generator.write(this.terms);
        if (this.numMatches != null) {
            generator.writeKey("num_matches");
            generator.write(this.numMatches);
        }
        if (ApiTypeHelper.isDefined(this.preferredToCategories)) {
            generator.writeKey("preferred_to_categories");
            generator.writeStartArray();
            for (String item0 : this.preferredToCategories) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.p != null) {
            generator.writeKey("p");
            generator.write(this.p);
        }
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("mlcategory");
        generator.write(this.mlcategory);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCategoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::categoryId, JsonpDeserializer.numberDeserializer(), "category_id");
        op.add(Builder::examples, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "examples");
        op.add(Builder::grokPattern, JsonpDeserializer.stringDeserializer(), "grok_pattern");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::maxMatchingLength, JsonpDeserializer.numberDeserializer(), "max_matching_length");
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name");
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value");
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), "regex");
        op.add(Builder::terms, JsonpDeserializer.stringDeserializer(), "terms");
        op.add(Builder::numMatches, JsonpDeserializer.longDeserializer(), "num_matches");
        op.add(Builder::preferredToCategories, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "preferred_to_categories");
        op.add(Builder::p, JsonpDeserializer.stringDeserializer(), "p");
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type");
        op.add(Builder::mlcategory, JsonpDeserializer.stringDeserializer(), "mlcategory");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Category> {
        private Number categoryId;
        private List<String> examples;
        @Nullable
        private String grokPattern;
        private String jobId;
        private Number maxMatchingLength;
        @Nullable
        private String partitionFieldName;
        @Nullable
        private String partitionFieldValue;
        private String regex;
        private String terms;
        @Nullable
        private Long numMatches;
        @Nullable
        private List<String> preferredToCategories;
        @Nullable
        private String p;
        private String resultType;
        private String mlcategory;

        public final Builder categoryId(Number value) {
            this.categoryId = value;
            return this;
        }

        public final Builder examples(List<String> list) {
            this.examples = Builder._listAddAll(this.examples, list);
            return this;
        }

        public final Builder examples(String value, String ... values) {
            this.examples = Builder._listAdd(this.examples, value, values);
            return this;
        }

        public final Builder grokPattern(@Nullable String value) {
            this.grokPattern = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder maxMatchingLength(Number value) {
            this.maxMatchingLength = value;
            return this;
        }

        public final Builder partitionFieldName(@Nullable String value) {
            this.partitionFieldName = value;
            return this;
        }

        public final Builder partitionFieldValue(@Nullable String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public final Builder regex(String value) {
            this.regex = value;
            return this;
        }

        public final Builder terms(String value) {
            this.terms = value;
            return this;
        }

        public final Builder numMatches(@Nullable Long value) {
            this.numMatches = value;
            return this;
        }

        public final Builder preferredToCategories(List<String> list) {
            this.preferredToCategories = Builder._listAddAll(this.preferredToCategories, list);
            return this;
        }

        public final Builder preferredToCategories(String value, String ... values) {
            this.preferredToCategories = Builder._listAdd(this.preferredToCategories, value, values);
            return this;
        }

        public final Builder p(@Nullable String value) {
            this.p = value;
            return this;
        }

        public final Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public final Builder mlcategory(String value) {
            this.mlcategory = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Category build() {
            this._checkSingleUse();
            return new Category(this);
        }
    }
}

