/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.MissingValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexShapeFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;
import org.elasticsearch.xpack.spatial.search.aggregations.support.ShapeValuesSourceType;

public class GeoShapeValuesSourceType
extends ShapeValuesSourceType {
    static GeoShapeValuesSourceType INSTANCE = new GeoShapeValuesSourceType();

    public static GeoShapeValuesSourceType instance() {
        return INSTANCE;
    }

    @Override
    public ValuesSource getEmpty() {
        return GeoShapeValuesSource.EMPTY;
    }

    @Override
    public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
        boolean isPoint = fieldContext.indexFieldData() instanceof IndexGeoPointFieldData;
        boolean isShape = fieldContext.indexFieldData() instanceof IndexShapeFieldData;
        if (!isPoint && !isShape) {
            throw new IllegalArgumentException("Expected geo_point or geo_shape type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
        }
        if (isPoint) {
            return new ValuesSource.GeoPoint.Fielddata((IndexGeoPointFieldData)fieldContext.indexFieldData());
        }
        return new GeoShapeValuesSource.Fielddata((IndexShapeFieldData)fieldContext.indexFieldData());
    }

    @Override
    public ValuesSource replaceMissing(final ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
        final GeoShapeValuesSource shapeValuesSource = (GeoShapeValuesSource)valuesSource;
        final GeoShapeValues.GeoShapeValue missing = (GeoShapeValues.GeoShapeValue)GeoShapeValues.EMPTY.missing(rawMissing.toString());
        return new GeoShapeValuesSource(this){

            @Override
            public GeoShapeValues shapeValues(LeafReaderContext context) {
                final GeoShapeValues values = (GeoShapeValues)shapeValuesSource.shapeValues(context);
                return new GeoShapeValues(){
                    private boolean exists;

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        this.exists = values.advanceExact(doc);
                        return true;
                    }

                    @Override
                    public ValuesSourceType valuesSourceType() {
                        return values.valuesSourceType();
                    }

                    @Override
                    public GeoShapeValues.GeoShapeValue value() throws IOException {
                        return this.exists ? (GeoShapeValues.GeoShapeValue)values.value() : missing;
                    }

                    public String toString() {
                        return "anon MultiShapeValues of [" + super.toString() + "]";
                    }
                };
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing(valuesSource.bytesValues(context), new BytesRef(missing.toString()));
            }
        };
    }

    @Override
    public String typeName() {
        return "geoshape";
    }
}

