/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.core.watcher.condition.ConditionRegistry;
import org.elasticsearch.xpack.core.watcher.support.WatcherUtils;
import org.elasticsearch.xpack.core.watcher.transform.TransformRegistry;

public class ActionRegistry {
    private final Map<String, ActionFactory> parsers;
    private final ConditionRegistry conditionRegistry;
    private final TransformRegistry transformRegistry;
    private final Clock clock;
    private final XPackLicenseState licenseState;

    public ActionRegistry(Map<String, ActionFactory> parsers, ConditionRegistry conditionRegistry, TransformRegistry transformRegistry, Clock clock, XPackLicenseState licenseState) {
        this.parsers = parsers;
        this.conditionRegistry = conditionRegistry;
        this.transformRegistry = transformRegistry;
        this.clock = clock;
        this.licenseState = licenseState;
    }

    ActionFactory factory(String type) {
        return this.parsers.get(type);
    }

    public List<ActionWrapper> parseActions(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse actions for watch [{}]. expected an object but found [{}] instead", new Object[]{watchId, parser.currentToken()});
        }
        ArrayList<ActionWrapper> actions = new ArrayList<ActionWrapper>();
        String id = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                id = parser.currentName();
                if (WatcherUtils.isValidId(id)) continue;
                throw new ElasticsearchParseException("could not parse action [{}] for watch [{}]. id contains whitespace", id, watchId);
            }
            if (token != XContentParser.Token.START_OBJECT || id == null) continue;
            actions.add(ActionWrapper.parse(watchId, id, parser, this, this.clock, this.licenseState));
        }
        return actions;
    }

    public TransformRegistry getTransformRegistry() {
        return this.transformRegistry;
    }

    public ConditionRegistry getConditionRegistry() {
        return this.conditionRegistry;
    }
}

