/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Influencer
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "influencer";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("influencer", new String[0]);
    public static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField INFLUENCER_FIELD_NAME = new ParseField("influencer_field_name", new String[0]);
    public static final ParseField INFLUENCER_FIELD_VALUE = new ParseField("influencer_field_value", new String[0]);
    public static final ParseField INITIAL_INFLUENCER_SCORE = new ParseField("initial_influencer_score", new String[0]);
    public static final ParseField INFLUENCER_SCORE = new ParseField("influencer_score", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("influencers", new String[0]);
    public static final ConstructingObjectParser<Influencer, Void> LENIENT_PARSER = new ConstructingObjectParser(RESULT_TYPE_FIELD.getPreferredName(), true, a -> new Influencer((String)a[0], (String)a[1], (String)a[2], (Date)a[3], (Long)a[4]));
    private final String jobId;
    private final Date timestamp;
    private final long bucketSpan;
    private String influenceField;
    private String influenceValue;
    private double probability;
    private double initialInfluencerScore;
    private double influencerScore;
    private boolean isInterim;

    public Influencer(String jobId, String fieldName, String fieldValue, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.influenceField = fieldName;
        this.influenceValue = fieldValue;
        this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        this.bucketSpan = bucketSpan;
    }

    public Influencer(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = new Date(in.readLong());
        this.influenceField = in.readString();
        this.influenceValue = in.readString();
        this.probability = in.readDouble();
        this.initialInfluencerScore = in.readDouble();
        this.influencerScore = in.readDouble();
        this.isInterim = in.readBoolean();
        this.bucketSpan = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.timestamp.getTime());
        out.writeString(this.influenceField);
        out.writeString(this.influenceValue);
        out.writeDouble(this.probability);
        out.writeDouble(this.initialInfluencerScore);
        out.writeDouble(this.influencerScore);
        out.writeBoolean(this.isInterim);
        out.writeLong(this.bucketSpan);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(INFLUENCER_FIELD_NAME.getPreferredName(), this.influenceField);
        builder.field(INFLUENCER_FIELD_VALUE.getPreferredName(), this.influenceValue);
        if (ReservedFieldNames.isValidFieldName(this.influenceField)) {
            builder.field(this.influenceField, this.influenceValue);
        }
        builder.field(INFLUENCER_SCORE.getPreferredName(), this.influencerScore);
        builder.field(INITIAL_INFLUENCER_SCORE.getPreferredName(), this.initialInfluencerScore);
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.timestampFieldsFromUnixEpochMillis(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return this.jobId + "_influencer_" + this.timestamp.getTime() + "_" + this.bucketSpan + "_" + this.influenceField + "_" + MachineLearningField.valuesToId(this.influenceValue);
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getInfluencerFieldName() {
        return this.influenceField;
    }

    public String getInfluencerFieldValue() {
        return this.influenceValue;
    }

    public double getInitialInfluencerScore() {
        return this.initialInfluencerScore;
    }

    public void setInitialInfluencerScore(double score) {
        this.initialInfluencerScore = score;
    }

    public double getInfluencerScore() {
        return this.influencerScore;
    }

    public void setInfluencerScore(double score) {
        this.influencerScore = score;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public void setInterim(boolean value) {
        this.isInterim = value;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.influenceField, this.influenceValue, this.initialInfluencerScore, this.influencerScore, this.probability, this.isInterim, this.bucketSpan);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Influencer other = (Influencer)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.influenceField, other.influenceField) && Objects.equals(this.influenceValue, other.influenceValue) && Double.compare(this.initialInfluencerScore, other.initialInfluencerScore) == 0 && Double.compare(this.influencerScore, other.influencerScore) == 0 && Double.compare(this.probability, other.probability) == 0 && this.isInterim == other.isInterim && this.bucketSpan == other.bucketSpan;
    }

    static {
        LENIENT_PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        LENIENT_PARSER.declareString(ConstructingObjectParser.constructorArg(), INFLUENCER_FIELD_NAME);
        LENIENT_PARSER.declareString(ConstructingObjectParser.constructorArg(), INFLUENCER_FIELD_VALUE);
        LENIENT_PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        LENIENT_PARSER.declareString((influencer, s) -> {}, Result.RESULT_TYPE);
        LENIENT_PARSER.declareDouble(Influencer::setProbability, PROBABILITY);
        LENIENT_PARSER.declareDouble(Influencer::setInfluencerScore, INFLUENCER_SCORE);
        LENIENT_PARSER.declareDouble(Influencer::setInitialInfluencerScore, INITIAL_INFLUENCER_SCORE);
        LENIENT_PARSER.declareBoolean(Influencer::setInterim, Result.IS_INTERIM);
    }
}

