/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.InferenceContext;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;

public class InferenceActionProxy
extends ActionType<InferenceAction.Response> {
    public static final InferenceActionProxy INSTANCE = new InferenceActionProxy();
    public static final String NAME = "cluster:monitor/xpack/inference/post";

    public InferenceActionProxy() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest {
        private final TaskType taskType;
        private final String inferenceEntityId;
        private final BytesReference content;
        private final XContentType contentType;
        private final TimeValue timeout;
        private final boolean stream;
        private final InferenceContext context;

        public Request(TaskType taskType, String inferenceEntityId, BytesReference content, XContentType contentType, TimeValue timeout, boolean stream, InferenceContext context) {
            this.taskType = taskType;
            this.inferenceEntityId = inferenceEntityId;
            this.content = content;
            this.contentType = contentType;
            this.timeout = timeout;
            this.stream = stream;
            this.context = context;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskType = TaskType.fromStream(in);
            this.inferenceEntityId = in.readString();
            this.content = in.readBytesReference();
            this.contentType = in.readEnum(XContentType.class);
            this.timeout = in.readTimeValue();
            this.stream = false;
            this.context = in.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_CONTEXT) || in.getTransportVersion().isPatchFrom(TransportVersions.INFERENCE_CONTEXT_8_X) ? new InferenceContext(in) : InferenceContext.EMPTY_INSTANCE;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        public BytesReference getContent() {
            return this.content;
        }

        public XContentType getContentType() {
            return this.contentType;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public boolean isStreaming() {
            return this.stream;
        }

        public InferenceContext getContext() {
            return this.context;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.taskType.writeTo(out);
            out.writeString(this.inferenceEntityId);
            out.writeBytesReference(this.content);
            XContentHelper.writeTo(out, this.contentType);
            out.writeTimeValue(this.timeout);
            if (out.getTransportVersion().onOrAfter(TransportVersions.INFERENCE_CONTEXT) || out.getTransportVersion().isPatchFrom(TransportVersions.INFERENCE_CONTEXT_8_X)) {
                this.context.writeTo(out);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.taskType == request.taskType && Objects.equals(this.inferenceEntityId, request.inferenceEntityId) && Objects.equals(this.content, request.content) && this.contentType == request.contentType && this.timeout == request.timeout && this.stream == request.stream && this.context == request.context;
        }

        public int hashCode() {
            return Objects.hash(this.taskType, this.inferenceEntityId, this.content, this.contentType, this.timeout, this.stream, this.context);
        }
    }
}

