/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobStoreActionStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.repositories.RepositoryInfo;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class RepositoryStatsSnapshot
implements Writeable,
ToXContentObject {
    public static final long UNKNOWN_CLUSTER_VERSION = -1L;
    private final RepositoryInfo repositoryInfo;
    private final RepositoryStats repositoryStats;
    private final long clusterVersion;
    private final boolean archived;

    public RepositoryStatsSnapshot(RepositoryInfo repositoryInfo, RepositoryStats repositoryStats, long clusterVersion, boolean archived) {
        assert (archived != (clusterVersion == -1L));
        this.repositoryInfo = repositoryInfo;
        this.repositoryStats = repositoryStats;
        this.clusterVersion = clusterVersion;
        this.archived = archived;
    }

    public RepositoryStatsSnapshot(StreamInput in) throws IOException {
        this.repositoryInfo = new RepositoryInfo(in);
        this.repositoryStats = new RepositoryStats(in);
        this.clusterVersion = in.readLong();
        this.archived = in.readBoolean();
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public RepositoryStats getRepositoryStats() {
        return this.repositoryStats;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public long getClusterVersion() {
        return this.clusterVersion;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.repositoryInfo.writeTo(out);
        this.repositoryStats.writeTo(out);
        out.writeLong(this.clusterVersion);
        out.writeBoolean(this.archived);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.repositoryInfo.toXContent(builder, params);
        builder.startObject("request_counts");
        for (Map.Entry<String, BlobStoreActionStats> entry : this.repositoryStats.actionStats.entrySet()) {
            BlobStoreActionStats stats = entry.getValue();
            builder.field(entry.getKey(), stats.operations());
        }
        builder.endObject();
        builder.field("archived", this.archived);
        if (this.archived) {
            builder.field("cluster_version", this.clusterVersion);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStatsSnapshot that = (RepositoryStatsSnapshot)o;
        return this.repositoryInfo.equals(that.repositoryInfo) && this.repositoryStats.equals(that.repositoryStats) && this.clusterVersion == that.clusterVersion && this.archived == that.archived;
    }

    public int hashCode() {
        return Objects.hash(this.repositoryInfo, this.repositoryStats, this.clusterVersion, this.archived);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

