/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.similarity.SimilarityProvider;

public record TextSearchInfo(FieldType luceneFieldType, SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer) {
    private static final FieldType SIMPLE_MATCH_ONLY_FIELD_TYPE;
    public static final TextSearchInfo SIMPLE_MATCH_ONLY;
    public static final TextSearchInfo WHITESPACE_MATCH_ONLY;
    public static final TextSearchInfo SIMPLE_MATCH_WITHOUT_TERMS;
    private static final NamedAnalyzer FORBIDDEN_ANALYZER;
    public static final TextSearchInfo NONE;

    public TextSearchInfo(FieldType luceneFieldType, SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer) {
        this.luceneFieldType = Mapper.freezeAndDeduplicateFieldType(luceneFieldType);
        this.similarity = similarity;
        this.searchAnalyzer = Objects.requireNonNull(searchAnalyzer);
        this.searchQuoteAnalyzer = Objects.requireNonNull(searchQuoteAnalyzer);
    }

    public boolean hasPositions() {
        return this.luceneFieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    public boolean hasOffsets() {
        return this.luceneFieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    public boolean hasNorms() {
        return !this.luceneFieldType.omitNorms();
    }

    public boolean isTokenized() {
        return this.luceneFieldType.tokenized();
    }

    public TermVector termVectors() {
        if (!this.luceneFieldType.storeTermVectors()) {
            return TermVector.NONE;
        }
        if (this.luceneFieldType.storeTermVectorOffsets()) {
            return TermVector.OFFSETS;
        }
        if (this.luceneFieldType.storeTermVectorPositions()) {
            return TermVector.POSITIONS;
        }
        return TermVector.DOCS;
    }

    static {
        FieldType ft = new FieldType();
        ft.setTokenized(false);
        ft.setOmitNorms(true);
        SIMPLE_MATCH_ONLY_FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType(ft);
        SIMPLE_MATCH_ONLY = new TextSearchInfo(SIMPLE_MATCH_ONLY_FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        WHITESPACE_MATCH_ONLY = new TextSearchInfo(SIMPLE_MATCH_ONLY_FIELD_TYPE, null, Lucene.WHITESPACE_ANALYZER, Lucene.WHITESPACE_ANALYZER);
        SIMPLE_MATCH_WITHOUT_TERMS = new TextSearchInfo(SIMPLE_MATCH_ONLY_FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        FORBIDDEN_ANALYZER = new NamedAnalyzer("", AnalyzerScope.GLOBAL, new Analyzer(){

            @Override
            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                throw new UnsupportedOperationException();
            }
        });
        NONE = new TextSearchInfo(SIMPLE_MATCH_ONLY_FIELD_TYPE, null, FORBIDDEN_ANALYZER, FORBIDDEN_ANALYZER);
    }

    public static enum TermVector {
        NONE,
        DOCS,
        POSITIONS,
        OFFSETS;

    }
}

