/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public abstract class FallbackSyntheticSourceBlockLoader
implements BlockLoader {
    private final Reader<?> reader;
    private final String fieldName;

    protected FallbackSyntheticSourceBlockLoader(Reader<?> reader, String fieldName) {
        this.reader = reader;
        this.fieldName = fieldName;
    }

    @Override
    public BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
        return null;
    }

    @Override
    public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
        return new IgnoredSourceRowStrideReader(this.fieldName, this.reader);
    }

    @Override
    public StoredFieldsSpec rowStrideStoredFieldSpec() {
        return new StoredFieldsSpec(false, false, Set.of("_ignored_source"));
    }

    @Override
    public boolean supportsOrdinals() {
        return false;
    }

    @Override
    public SortedSetDocValues ordinals(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static interface Reader<T> {
        public void convertValue(Object var1, List<T> var2);

        public void parse(XContentParser var1, List<T> var2) throws IOException;

        public void writeToBlock(List<T> var1, BlockLoader.Builder var2);
    }

    private record IgnoredSourceRowStrideReader<T>(String fieldName, Reader<T> reader) implements BlockLoader.RowStrideReader
    {
        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            List<Object> ignoredSource = storedFields.storedFields().get("_ignored_source");
            if (ignoredSource == null) {
                builder.appendNull();
                return;
            }
            HashMap<String, List<IgnoredSourceFieldMapper.NameValue>> valuesForFieldAndParents = new HashMap<String, List<IgnoredSourceFieldMapper.NameValue>>();
            HashSet<String> fieldNames = new HashSet<String>(){
                {
                    this.add("_doc");
                }
            };
            StringBuilder current = new StringBuilder();
            for (String part : this.fieldName.split("\\.")) {
                if (!current.isEmpty()) {
                    current.append('.');
                }
                current.append(part);
                fieldNames.add(current.toString());
            }
            for (Object e : ignoredSource) {
                IgnoredSourceFieldMapper.NameValue nameValue = IgnoredSourceFieldMapper.decode(e);
                if (!fieldNames.contains(nameValue.name())) continue;
                valuesForFieldAndParents.computeIfAbsent(nameValue.name(), k -> new ArrayList()).add(nameValue);
            }
            ArrayList blockValues = new ArrayList();
            List list = (List)valuesForFieldAndParents.get(this.fieldName);
            if (list != null) {
                this.readFromFieldValue(list, blockValues);
            } else {
                this.readFromParentValue(valuesForFieldAndParents, blockValues);
            }
            if (!blockValues.isEmpty()) {
                if (blockValues.size() > 1) {
                    builder.beginPositionEntry();
                }
                this.reader.writeToBlock(blockValues, builder);
                if (blockValues.size() > 1) {
                    builder.endPositionEntry();
                }
            } else {
                builder.appendNull();
            }
        }

        private void readFromFieldValue(List<IgnoredSourceFieldMapper.NameValue> nameValues, List<T> blockValues) throws IOException {
            if (nameValues.isEmpty()) {
                return;
            }
            for (IgnoredSourceFieldMapper.NameValue nameValue : nameValues) {
                Optional<Object> singleValue = XContentDataHelper.decode(nameValue.value());
                if (singleValue.isPresent()) {
                    this.reader.convertValue(singleValue.get(), blockValues);
                    continue;
                }
                Optional<XContentType> type = XContentDataHelper.decodeType(nameValue.value());
                assert (type.isPresent());
                XContentParser parser = type.get().xContent().createParser(XContentParserConfiguration.EMPTY, nameValue.value().bytes, nameValue.value().offset + 1, nameValue.value().length - 1);
                try {
                    parser.nextToken();
                    this.parseWithReader(parser, blockValues);
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
        }

        private void readFromParentValue(Map<String, List<IgnoredSourceFieldMapper.NameValue>> valuesForFieldAndParents, List<T> blockValues) throws IOException {
            if (valuesForFieldAndParents.isEmpty()) {
                return;
            }
            assert (valuesForFieldAndParents.size() == 1) : "_ignored_source field contains multiple levels of the same object";
            List<IgnoredSourceFieldMapper.NameValue> parentValues = valuesForFieldAndParents.values().iterator().next();
            for (IgnoredSourceFieldMapper.NameValue nameValue : parentValues) {
                this.parseFieldFromParent(nameValue, blockValues);
            }
        }

        private void parseFieldFromParent(final IgnoredSourceFieldMapper.NameValue nameValue, List<T> blockValues) throws IOException {
            Optional<XContentType> type = XContentDataHelper.decodeType(nameValue.value());
            assert (type.isPresent());
            String nameAtThisLevel = this.fieldName.substring(nameValue.name().length() + 1);
            XContentParserConfiguration filterParserConfig = XContentParserConfiguration.EMPTY.withFiltering(null, Set.of(nameAtThisLevel), Set.of(), true);
            try (XContentParser parser = type.get().xContent().createParser(filterParserConfig, nameValue.value().bytes, nameValue.value().offset + 1, nameValue.value().length - 1);){
                parser.nextToken();
                Stack<String> fieldNames = new Stack<String>(){
                    {
                        this.push(nameValue.name());
                    }
                };
                while (parser.currentToken() != null) {
                    while (true) {
                        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                            fieldNames.push(parser.currentName());
                            String nameInParser = String.join((CharSequence)".", (Iterable<? extends CharSequence>)fieldNames);
                            if (nameInParser.equals(this.fieldName)) {
                                break;
                            }
                        } else assert (parser.currentToken() == XContentParser.Token.START_OBJECT || parser.currentToken() == XContentParser.Token.START_ARRAY);
                        parser.nextToken();
                    }
                    parser.nextToken();
                    this.parseWithReader(parser, blockValues);
                    parser.nextToken();
                    while (parser.currentToken() == XContentParser.Token.END_OBJECT || parser.currentToken() == XContentParser.Token.END_ARRAY) {
                        if (parser.currentToken() == XContentParser.Token.END_OBJECT) {
                            fieldNames.pop();
                        }
                        parser.nextToken();
                    }
                }
            }
        }

        private void parseWithReader(XContentParser parser, List<T> blockValues) throws IOException {
            this.reader.parse(parser, blockValues);
        }

        @Override
        public boolean canReuse(int startingDocID) {
            return true;
        }
    }

    public static abstract class SingleValueReader<T>
    implements Reader<T> {
        private final Object nullValue;

        public SingleValueReader(Object nullValue) {
            this.nullValue = nullValue;
        }

        @Override
        public void parse(XContentParser parser, List<T> accumulator) throws IOException {
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    this.convertValue(this.nullValue, accumulator);
                }
                return;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                        if (this.nullValue == null) continue;
                        this.convertValue(this.nullValue, accumulator);
                        continue;
                    }
                    this.parseNonNullValue(parser, accumulator);
                }
                return;
            }
            this.parseNonNullValue(parser, accumulator);
        }

        protected abstract void parseNonNullValue(XContentParser var1, List<T> var2) throws IOException;
    }
}

