/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch.cluster.reroute.RerouteExplanation;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RerouteResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final List<RerouteExplanation> explanations;
    @Nullable
    private final JsonData state;
    public static final JsonpDeserializer<RerouteResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteResponse::setupRerouteResponseDeserializer);

    private RerouteResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, (Object)this, "acknowledged", false);
        this.explanations = ApiTypeHelper.unmodifiable(builder.explanations);
        this.state = builder.state;
    }

    public static RerouteResponse of(Function<Builder, ObjectBuilder<RerouteResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final List<RerouteExplanation> explanations() {
        return this.explanations;
    }

    @Nullable
    public final JsonData state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        if (ApiTypeHelper.isDefined(this.explanations)) {
            generator.writeKey("explanations");
            generator.writeStartArray();
            for (RerouteExplanation item0 : this.explanations) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.state != null) {
            generator.writeKey("state");
            this.state.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRerouteResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::explanations, JsonpDeserializer.arrayDeserializer(RerouteExplanation._DESERIALIZER), "explanations");
        op.add(Builder::state, JsonData._DESERIALIZER, "state");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RerouteResponse> {
        private Boolean acknowledged;
        @Nullable
        private List<RerouteExplanation> explanations;
        @Nullable
        private JsonData state;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder explanations(List<RerouteExplanation> list) {
            this.explanations = Builder._listAddAll(this.explanations, list);
            return this;
        }

        public final Builder explanations(RerouteExplanation value, RerouteExplanation ... values) {
            this.explanations = Builder._listAdd(this.explanations, value, values);
            return this;
        }

        public final Builder explanations(Function<RerouteExplanation.Builder, ObjectBuilder<RerouteExplanation>> fn) {
            return this.explanations(fn.apply(new RerouteExplanation.Builder()).build(), new RerouteExplanation[0]);
        }

        public final Builder state(@Nullable JsonData value) {
            this.state = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RerouteResponse build() {
            this._checkSingleUse();
            return new RerouteResponse(this);
        }
    }
}

