/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public class RealHashScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String lockString;
    public String tableName;
    public String indexName;
    public String nextQualifiers;
    public String scanQualifiers;
    public String startPosition = null;
    public String stopPosition = null;
    public FormatableProperties scanProperties;

    public RealHashScanStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String indexName, boolean isConstraint, int hashtableSize, int[] hashKeyColumns, String scanQualifiers, String nextQualifiers, Properties scanProperties, String startPosition, String stopPosition, String isolationLevel, String lockString, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableName = tableName;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.hashtableSize = hashtableSize;
        this.hashKeyColumns = ArrayUtil.copy((int[])hashKeyColumns);
        this.scanQualifiers = scanQualifiers;
        this.nextQualifiers = nextQualifiers;
        this.scanProperties = new FormatableProperties();
        if (scanProperties != null) {
            Enumeration<Object> e = scanProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.scanProperties.put(key, scanProperties.get(key));
            }
        }
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.isolationLevel = isolationLevel;
        this.lockString = lockString;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        String hashKeyColumnString;
        Object isolationString = null;
        this.initFormatInfo(depth);
        String header = this.indexName != null ? this.indent + MessageService.getTextMessage((String)"43X51.U", (Object[])new Object[]{this.tableName, this.isConstraint ? "constraint" : "index", this.indexName}) : this.indent + MessageService.getTextMessage((String)"43X52.U", (Object[])new Object[]{this.tableName});
        header = header + " " + MessageService.getTextMessage((String)"43X27.U", (Object[])new Object[]{this.isolationLevel, this.lockString}) + ": \n";
        String scanInfo = this.indent + MessageService.getTextMessage((String)"43X28.U", (Object[])new Object[0]) + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        if (this.hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage((String)"43X53.U", (Object[])new Object[0]) + " " + this.hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage((String)"43X54.U", (Object[])new Object[0]) + " (" + this.hashKeyColumns[0];
            for (int index = 1; index < this.hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + this.hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return header + this.indent + MessageService.getTextMessage((String)"43X03.U", (Object[])new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage((String)"43X31.U", (Object[])new Object[0]) + " = " + this.hashtableSize + "\n" + this.indent + hashKeyColumnString + "\n" + this.indent + MessageService.getTextMessage((String)"43X04.U", (Object[])new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage((String)"43X32.U", (Object[])new Object[0]) + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (String)(this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage((String)"43X33.U", (Object[])new Object[0]) + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + scanInfo + this.subIndent + MessageService.getTextMessage((String)"43X34.U", (Object[])new Object[0]) + ":\n" + StringUtil.ensureIndent(this.startPosition, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage((String)"43X35.U", (Object[])new Object[0]) + ":\n" + StringUtil.ensureIndent(this.stopPosition, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage((String)"43X36.U", (Object[])new Object[0]) + ":\n" + StringUtil.ensureIndent(this.scanQualifiers, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage((String)"43X37.U", (Object[])new Object[0]) + ":\n" + StringUtil.ensureIndent(this.nextQualifiers, depth + 2) + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeOn() {
        return MessageService.getTextMessage((String)"43X38.U", (Object[])new Object[]{this.tableName, this.indexName});
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage((String)"43X55.U", (Object[])new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public String getRSXplainType() {
        return "HASHSCAN";
    }

    @Override
    public String getRSXplainDetails() {
        if (this.indexName != null) {
            return (this.isConstraint ? "C: " : "I: ") + this.indexName;
        }
        return "T: " + this.tableName;
    }

    @Override
    public Object getScanPropsDescriptor(Object scanPropsID) {
        String scanObjectName;
        String scanObjectType;
        if (this.indexName != null) {
            if (this.isConstraint) {
                scanObjectType = "C";
                scanObjectName = this.indexName;
            } else {
                scanObjectType = "I";
                scanObjectName = this.indexName;
            }
        } else {
            scanObjectType = "T";
            scanObjectName = this.tableName;
        }
        String isoLevel = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        String hashkey_columns = XPLAINUtil.getHashKeyColumnNumberString(this.hashKeyColumns);
        XPLAINScanPropsDescriptor scanRSDescriptor = new XPLAINScanPropsDescriptor((UUID)scanPropsID, scanObjectName, scanObjectType, null, isoLevel, null, null, null, null, null, null, null, null, this.startPosition, this.stopPosition, this.scanQualifiers, this.nextQualifiers, hashkey_columns, this.hashtableSize);
        FormatableProperties props = this.scanProperties;
        return XPLAINUtil.extractScanProps(scanRSDescriptor, props);
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        String lockMode = XPLAINUtil.getLockModeCode(this.lockString);
        String lockGran = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, lockMode, lockGran, (UUID)parentID, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeen, null, this.rowsFiltered, this.rowsSeen - this.rowsFiltered, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

