"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _types = require("../../app/types");
var _header_page = require("../../common/components/header_page");
var _nav_links = require("../../common/links/nav_links");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _trackers = require("../../common/lib/telemetry/trackers");
var _global_query_string = require("../../common/utils/global_query_string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.landing.pageTitle', {
  defaultMessage: 'Entity analytics'
});
const EntityAnalyticsLandingPage = () => {
  const entityAnalyticsLandingNavLink = (0, _nav_links.useRootNavLink)(_types.SecurityPageName.entityAnalyticsLanding);
  const entityAnalyticsLandinglinks = entityAnalyticsLandingNavLink && 'links' in entityAnalyticsLandingNavLink && Array.isArray(entityAnalyticsLandingNavLink.links) ? entityAnalyticsLandingNavLink.links : [];
  const entityAnalyticsOverviewNavLink = (0, _nav_links.useRootNavLink)(_types.SecurityPageName.entityAnalyticsOverview);
  const entityAnalyticsOverviewlinks = entityAnalyticsOverviewNavLink && 'links' in entityAnalyticsOverviewNavLink && Array.isArray(entityAnalyticsOverviewNavLink.links) ? entityAnalyticsOverviewNavLink.links : [];
  const urlState = (0, _global_query_string.useGlobalQueryString)();
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: PAGE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksImages, {
    items: entityAnalyticsLandinglinks,
    urlState: urlState,
    onLinkClick: _trackers.trackLandingLinkClick
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalyticsLanding
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksImages, {
    items: entityAnalyticsOverviewlinks,
    urlState: urlState,
    onLinkClick: _trackers.trackLandingLinkClick
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalyticsOverview
  }));
};
exports.EntityAnalyticsLandingPage = EntityAnalyticsLandingPage;