"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGrantedRightsColumns = exports.buildAuthenticationsColumns = exports.buildAccountSwitchesColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _empty_value = require("../../../../../common/components/empty_value");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _user_name = require("../../../user_name");
var _helpers = require("../../../../../common/components/tables/helpers");
var _network_details = require("../../../network_details");
var _panel_keys = require("../../../../../flyout/document_details/shared/constants/panel_keys");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLUMN_WIDTHS = {
  actions: '5%',
  '@timestamp': '20%',
  privileged_user: '15%'
};
const timestampColumn = {
  field: '@timestamp',
  truncateText: true,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.timestamp",
    defaultMessage: "Timestamp"
  }),
  width: COLUMN_WIDTHS['@timestamp'],
  dataType: 'date',
  render: timestamp => {
    if (!timestamp) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(timestamp)
    });
  }
};
const getPrivilegedUserColumn = () => ({
  field: 'privileged_user',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.privilegedUser",
    defaultMessage: "Privileged user"
  }),
  width: COLUMN_WIDTHS.privileged_user,
  render: user => (0, _helpers.getRowItemsWithActions)({
    values: (0, _fp.isArray)(user) ? user : [user],
    fieldName: 'user.name',
    idPrefix: 'privileged-user-monitoring-privileged-user',
    render: item => /*#__PURE__*/_react.default.createElement(_user_name.UserName, {
      userName: item,
      scopeId: _constants.SCOPE_ID
    }),
    displayCount: 1
  })
});
const getTargetUserColumn = () => ({
  field: 'target_user',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.targetUser",
    defaultMessage: "Target user"
  }),
  render: user => user != null ? /*#__PURE__*/_react.default.createElement(_user_name.UserName, {
    userName: user,
    scopeId: _constants.SCOPE_ID
  }) : (0, _empty_value.getEmptyTagValue)()
});
const getIpColumn = (fieldName = 'source.ip') => ({
  field: 'host_ip',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.sourceIp",
    defaultMessage: "Source IP"
  }),
  render: ips => (0, _helpers.getRowItemsWithActions)({
    values: (0, _fp.isArray)(ips) ? ips : [ips],
    fieldName: '',
    // Dirty hack to disable CellActions, remove this when CellActions support multiple fields
    idPrefix: 'privileged-user-monitoring-ip',
    render: item => /*#__PURE__*/_react.default.createElement(_network_details.NetworkDetails, {
      ip: item
    }),
    displayCount: 1
  })
});
const getActionsColumn = openRightPanel => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.actions",
    defaultMessage: "Actions"
  }),
  render: record => {
    const onClick = () => {
      openRightPanel({
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: record._id,
          indexName: record._index,
          scopeId: _constants.SCOPE_ID
        }
      });
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "expand",
      onClick: onClick,
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.preview.ariaLabel', {
        defaultMessage: 'Preview event with id {id}',
        values: {
          id: record._id
        }
      })
    });
  },
  width: COLUMN_WIDTHS.actions
});
const buildGrantedRightsColumns = openRightPanel => [getActionsColumn(openRightPanel), timestampColumn, getPrivilegedUserColumn(), getTargetUserColumn(), {
  field: 'group_name',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.grantedRight",
    defaultMessage: "Granted right"
  })
}, getIpColumn('host.ip')];
exports.buildGrantedRightsColumns = buildGrantedRightsColumns;
const buildAccountSwitchesColumns = openRightPanel => [getActionsColumn(openRightPanel), timestampColumn, getPrivilegedUserColumn(), {
  ...getTargetUserColumn(),
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.targetAccount",
    defaultMessage: "Target account"
  })
}, {
  field: 'group_name',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.groupName",
    defaultMessage: "Target admin group"
  })
}, {
  field: 'command_process',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.commandProcess",
    defaultMessage: "Command/Process"
  })
}, getIpColumn('host.ip')];
exports.buildAccountSwitchesColumns = buildAccountSwitchesColumns;
const buildAuthenticationsColumns = openRightPanel => [getActionsColumn(openRightPanel), timestampColumn, getPrivilegedUserColumn(), {
  field: 'source',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.source",
    defaultMessage: "Source"
  }),
  render: source => {
    if (!source) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return (0, _fp.capitalize)(source);
  }
}, {
  field: 'type',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.type",
    defaultMessage: "Type"
  }),
  render: type => {
    if (!type) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return type;
  }
},
// TODO Add the column depending on this ticket output https://github.com/elastic/security-team/issues/12713
// {
//   field: 'method',
//   name: (
//     <FormattedMessage
//       id="xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.method"
//       defaultMessage="Method"
//     />
//   ),
//   render: (method: string) => {
//     // TODO: Implement method rendering logic
//     return '// TODO';
//   },
// },
{
  field: 'result',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.result",
    defaultMessage: "Result"
  }),
  render: result => {
    if (!result) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: getResultColor(result)
    }, (0, _fp.capitalize)(result));
  }
}, getIpColumn(), {
  field: 'destination',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.destination",
    defaultMessage: "Destination"
  })
}];
exports.buildAuthenticationsColumns = buildAuthenticationsColumns;
const getResultColor = value => {
  const valueLowerCase = value.toLocaleLowerCase();
  if (valueLowerCase === 'success') {
    return 'success';
  }
  if (valueLowerCase === 'failure') {
    return 'danger';
  }
  return 'default';
};