"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityStoreMissingPrivilegesCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _missing_privileges_callout = require("../../missing_privileges_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityStoreMissingPrivilegesCallout = ({
  privileges
}) => /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallout, {
  privileges: privileges,
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.title",
    defaultMessage: "Insufficient privileges to enable the Entity Store"
  })
});
exports.EntityStoreMissingPrivilegesCallout = EntityStoreMissingPrivilegesCallout;