"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewTacticPanel = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _panel_rule_stats = require("./shared_components/panel_rule_stats");
var _mitre_technique = require("../../../rule_management/model/coverage_overview/mitre_technique");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewTacticPanelComponent = ({
  tactic
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const coveredTechniques = (0, _react2.useMemo)(() => (0, _mitre_technique.getNumOfCoveredTechniques)(tactic), [tactic]);
  const ProgressLabel = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "success"
  }, /*#__PURE__*/_react2.default.createElement("h5", null, i18n.COVERED_MITRE_TECHNIQUES(coveredTechniques, tactic.techniques.length))), [tactic.techniques, coveredTechniques]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "coverageOverviewTacticPanel",
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    css: (0, _react.css)`
        background: ${euiTheme.colors.lightestShade};
        border-color: ${euiTheme.colors.mediumShade};
        width: ${_constants.coverageOverviewPanelWidth}px;
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: tactic.name
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    css: (0, _react.css)`
            h4 {
              white-space: nowrap;
              overflow: hidden;
              text-overflow: ellipsis;
            }
          `,
    "aria-label": tactic.name,
    title: tactic.name,
    grow: false,
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement("h4", null, tactic.name))), /*#__PURE__*/_react2.default.createElement(_eui.EuiProgress, {
    color: "success",
    value: coveredTechniques,
    label: ProgressLabel,
    max: tactic.techniques.length
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_panel_rule_stats.CoverageOverviewPanelRuleStats, {
    enabledRules: tactic.enabledRules.length,
    disabledRules: tactic.disabledRules.length
  }));
};
const CoverageOverviewTacticPanel = exports.CoverageOverviewTacticPanel = /*#__PURE__*/(0, _react2.memo)(CoverageOverviewTacticPanelComponent);