"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _react2 = _interopRequireWildcard(require("react"));
var _animated_counter = require("./animated_counter");
var _generate = require("../generate");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_kibana_feature_flags = require("../../../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPromptComponent = ({
  aiConnectorsCount,
  alertsCount,
  attackDiscoveriesCount,
  isLoading,
  isDisabled = false,
  onGenerate
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const currentTitle = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "emptyPromptTitleContainer",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAvatar",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_aiAssistantIcon.AssistantBeacon, {
    size: "xl",
    backgroundColor: "emptyShade"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                margin-right: ${euiTheme.size.xs};
              `,
    "data-test-subj": "upTo",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.UP_TO)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAnimatedCounter",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_animated_counter.AnimatedCounter, {
    count: alertsCount
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAlertsWillBeAnalyzed",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.ALERTS_WILL_BE_ANALYZED(alertsCount))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                margin-left: ${euiTheme.size.xs};
              `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    content: i18n.RESPONSES_FROM_AI_SYSTEMS,
    "data-test-subj": "responsesFromAiSystemsTooltip",
    position: "right",
    type: "info"
  }))))), [alertsCount, euiTheme.size.xs]);
  const historyTitle = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "bodyContainer",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptAvatar",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_aiAssistantIcon.AssistantBeacon, {
    size: "xl",
    backgroundColor: "emptyShade"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "historyTitle",
    size: "m"
  }, /*#__PURE__*/_react2.default.createElement("h1", null, i18n.NO_RESULTS_MATCH_YOUR_SEARCH)))), []);
  const currentBody = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "bodyContainer",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "startGeneratingDiscoveriesLabel"
  }, i18n.START_GENERATING_DISCOVERIES))), []);
  const historyBody = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "historyBody",
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            display: inline-flex;
            text-align: left;
          `,
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", null, i18n.HERE_ARE_SOME_THINGS_TO_TRY), /*#__PURE__*/_react2.default.createElement("ul", {
    css: (0, _react.css)`
              text-align: left;
            `
  }, /*#__PURE__*/_react2.default.createElement("li", null, /*#__PURE__*/_react2.default.createElement("span", null, i18n.EXPAND_THE_TIME_RANGE)), /*#__PURE__*/_react2.default.createElement("li", null, /*#__PURE__*/_react2.default.createElement("span", null, i18n.GENERATE_NEW_ATTACK_DISCOVERIES))))), []);
  const actions = (0, _react2.useMemo)(() => {
    return /*#__PURE__*/_react2.default.createElement(_generate.Generate, {
      isLoading: isLoading,
      isDisabled: isDisabled,
      onGenerate: onGenerate
    });
  }, [isDisabled, isLoading, onGenerate]);
  if (isLoading || aiConnectorsCount == null || attackDiscoveriesCount > 0) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "emptyPrompt",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "emptyPromptContainer",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    actions: actions,
    body: attackDiscoveryAlertsEnabled ? historyBody : currentBody,
    title: attackDiscoveryAlertsEnabled ? historyTitle : currentTitle
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    "data-test-subj": "learnMore",
    href: "https://www.elastic.co/guide/en/security/current/attack-discovery.html",
    target: "_blank"
  }, i18n.LEARN_MORE)));
};
const EmptyPrompt = exports.EmptyPrompt = /*#__PURE__*/_react2.default.memo(EmptyPromptComponent);