"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LangSmithOptions = exports.LangSmithEvaluationOptions = exports.ConnectorId = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: SIEM Rule Migration common components
 *   version: not applicable
 */

/**
 * The GenAI connector id to use.
 */

const ConnectorId = exports.ConnectorId = _zod.z.string();

/**
 * The LangSmith options object.
 */

const LangSmithOptions = exports.LangSmithOptions = _zod.z.object({
  /**
   * The project name.
   */
  project_name: _zod.z.string(),
  /**
   * The API key to use for tracing.
   */
  api_key: _zod.z.string()
});

/**
 * The LangSmith settings object for evaluations.
 */

const LangSmithEvaluationOptions = exports.LangSmithEvaluationOptions = LangSmithOptions.merge(_zod.z.object({
  /**
   * The dataset name to use for evaluations.
   */
  dataset: _zod.z.string()
}));