"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksIcons = exports.LandingLinkIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _beta_badge = require("./beta_badge");
var _landing_links = require("./landing_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLinkIconStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    title: (0, _react2.css)`
      min-height: ${euiTheme.size.l};
      margin-top: ${euiTheme.size.m};
      margin-bottom: ${euiTheme.size.xs};
    `,
    description: (0, _react2.css)`
      max-width: 22em;
    `
  };
};
const LandingLinkIcon = exports.LandingLinkIcon = /*#__PURE__*/_react.default.memo(function LandingLinkIcon({
  item,
  urlState,
  onLinkClick,
  children
}) {
  const styles = useLinkIconStyles();
  const {
    title,
    description,
    landingIcon,
    isBeta,
    betaOptions
  } = item;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": "LandingItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "aria-hidden": "true",
    size: "xl",
    type: landingIcon !== null && landingIcon !== void 0 ? landingIcon : '',
    role: "presentation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: styles.title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_landing_links.LandingLink, {
    item: item,
    urlState: urlState,
    onLinkClick: onLinkClick
  }, title)), isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.description
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children));
});
const linkIconContainerStyles = (0, _react2.css)`
  min-width: 22em;
`;
const LandingLinksIcons = ({
  items,
  urlState,
  onLinkClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    wrap: true
  }, items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.id,
    grow: false,
    css: linkIconContainerStyles
  }, /*#__PURE__*/_react.default.createElement(LandingLinkIcon, {
    item: item,
    urlState: urlState,
    onLinkClick: onLinkClick
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.LandingLinksIcons = LandingLinksIcons;
var _default = exports.default = LandingLinksIcons;