"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexDetails = ({
  index
}) => {
  const {
    time,
    name
  } = index;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "prfDevTool__profileTree__shardDetails"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.searchProfiler.profileTree.indexTitle', {
    defaultMessage: 'Index:'
  })), ' ' + name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "prfDevTool__profileTree__indexDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "prfDevTool__profileTree__shardDetails--dim"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: _i18n.i18n.translate('xpack.searchProfiler.profileTree.cumulativeTimeTooltip', {
      defaultMessage: 'The cumulative time of all shards in the index. Note: this is not wall-clock time, as shards can execute in parallel.'
    })
  }, /*#__PURE__*/_react.default.createElement("small", {
    tabIndex: 0
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.cumulativeTimeTitle', {
    defaultMessage: 'Cumulative time:'
  }))), ' ' + (0, _lib.msToPretty)(time, 3))));
};
exports.IndexDetails = IndexDetails;