"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _full_body_height_css = require("@kbn/css-utils/public/full_body_height_css");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _react2 = require("@emotion/react");
var _components = require("./components");
var _contexts = require("./contexts");
var _lib = require("./lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const componentStyles = {
  appRoot: ({
    euiTheme
  }) => (0, _react2.css)([{
    overflow: 'hidden',
    flexShrink: 1
  },
  // adding dev tool top bar to the body offset
  (0, _full_body_height_css.kbnFullBodyHeightCss)(`(${euiTheme.size.base} * 3)`)])
};
const App = () => {
  const {
    getLicenseStatus,
    notifications
  } = (0, _contexts.useAppContext)();
  const {
    activeTab,
    currentResponse,
    highlightDetails,
    pristine,
    profiling
  } = (0, _contexts.useProfilerReadContext)();
  const dispatch = (0, _contexts.useProfilerActionContext)();
  const handleProfileTreeError = e => {
    notifications.addError(e, {
      title: _i18n.i18n.translate('xpack.searchProfiler.profileTreeErrorRenderTitle', {
        defaultMessage: 'Profile data cannot be parsed.'
      })
    });
  };
  const setActiveTab = (0, _react.useCallback)(target => dispatch({
    type: 'setActiveTab',
    value: target
  }), [dispatch]);
  const onHighlight = (0, _react.useCallback)(value => dispatch({
    type: 'setHighlightDetails',
    value
  }), [dispatch]);
  const renderLicenseWarning = () => {
    return !getLicenseStatus().valid ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.LicenseWarningNotice, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })) : null;
  };
  const renderProfileTreeArea = () => {
    if (profiling) {
      return /*#__PURE__*/_react.default.createElement(_components.ProfileLoadingPlaceholder, null);
    }
    if (activeTab) {
      return /*#__PURE__*/_react.default.createElement(_components.ProfileTree, {
        onDataInitError: handleProfileTreeError,
        onHighlight: onHighlight,
        target: activeTab,
        data: currentResponse
      });
    }
    if (getLicenseStatus().valid && pristine) {
      return /*#__PURE__*/_react.default.createElement(_components.EmptyTreePlaceHolder, null);
    }
    return null;
  };
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    className: "prfDevTool__page",
    css: styles.appRoot
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    className: "prfDevTool__page__pageBody"
  }, renderLicenseWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "prfDevTool__page__pageBodyContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    direction: "row",
    className: "prfDevTool__page__bodyGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.ProfileQueryEditor, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "prfDevTool__main",
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_components.SearchProfilerTabs, {
    activeTab: activeTab,
    activateTab: setActiveTab,
    has: {
      aggregations: Boolean(currentResponse && (0, _lib.hasAggregations)(currentResponse)),
      searches: Boolean(currentResponse && (0, _lib.hasSearch)(currentResponse))
    }
  }), renderProfileTreeArea()))), highlightDetails ? /*#__PURE__*/_react.default.createElement(_components.HighlightDetailsFlyout, (0, _extends2.default)({}, highlightDetails, {
    onClose: () => dispatch({
      type: 'setHighlightDetails',
      value: null
    })
  })) : null))));
};
exports.App = App;