"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSavedPlaygroundError = fetchSavedPlaygroundError;
exports.parseSavedPlayground = parseSavedPlayground;
var _common = require("../../common");
var _prompt = require("../../common/prompt");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function parseSummarizationModel(model, models) {
  if (!model) {
    return undefined;
  }
  if (model.modelId) {
    const exactMatch = models.find(llm => llm.connectorId === model.connectorId && llm.name === model.modelId);
    if (exactMatch) {
      return exactMatch;
    }
  }
  return models.find(llm => llm.connectorId === model.connectorId);
}
function parseSavedPlayground(playground, models) {
  var _playground$data$user, _playground$data$prom, _playground$data$cita, _ref, _playground$data$cont, _playground$data$cont2, _playground$data$cont3;
  return {
    [_types.SavedPlaygroundFormFields.name]: playground.data.name,
    [_types.SavedPlaygroundFormFields.indices]: playground.data.indices,
    [_types.SavedPlaygroundFormFields.queryFields]: playground.data.queryFields,
    [_types.SavedPlaygroundFormFields.elasticsearchQuery]: JSON.parse(playground.data.elasticsearchQueryJSON),
    // TODO: replace with function
    [_types.SavedPlaygroundFormFields.userElasticsearchQuery]: (_playground$data$user = playground.data.userElasticsearchQueryJSON) !== null && _playground$data$user !== void 0 ? _playground$data$user : null,
    [_types.SavedPlaygroundFormFields.prompt]: (_playground$data$prom = playground.data.prompt) !== null && _playground$data$prom !== void 0 ? _playground$data$prom : _prompt.DEFAULT_LLM_PROMPT,
    [_types.SavedPlaygroundFormFields.citations]: (_playground$data$cita = playground.data.citations) !== null && _playground$data$cita !== void 0 ? _playground$data$cita : false,
    [_types.SavedPlaygroundFormFields.sourceFields]: (_ref = (_playground$data$cont = playground.data.context) === null || _playground$data$cont === void 0 ? void 0 : _playground$data$cont.sourceFields) !== null && _ref !== void 0 ? _ref : {},
    [_types.SavedPlaygroundFormFields.docSize]: (_playground$data$cont2 = (_playground$data$cont3 = playground.data.context) === null || _playground$data$cont3 === void 0 ? void 0 : _playground$data$cont3.docSize) !== null && _playground$data$cont2 !== void 0 ? _playground$data$cont2 : _common.DEFAULT_CONTEXT_DOCUMENTS,
    [_types.SavedPlaygroundFormFields.summarizationModel]: parseSummarizationModel(playground.data.summarizationModel, models),
    [_types.SavedPlaygroundFormFields.question]: '',
    [_types.SavedPlaygroundFormFields.searchQuery]: ''
  };
}
function fetchSavedPlaygroundError(e) {
  return {
    [_types.SavedPlaygroundFormFields.name]: '',
    [_types.SavedPlaygroundFormFields.indices]: [],
    [_types.SavedPlaygroundFormFields.queryFields]: {},
    [_types.SavedPlaygroundFormFields.elasticsearchQuery]: {
      retriever: {}
    },
    [_types.SavedPlaygroundFormFields.userElasticsearchQuery]: null,
    [_types.SavedPlaygroundFormFields.prompt]: '',
    [_types.SavedPlaygroundFormFields.citations]: false,
    [_types.SavedPlaygroundFormFields.sourceFields]: {},
    [_types.SavedPlaygroundFormFields.docSize]: 0,
    [_types.SavedPlaygroundFormFields.summarizationModel]: undefined,
    [_types.SavedPlaygroundFormFields.question]: '',
    [_types.SavedPlaygroundFormFields.searchQuery]: '',
    error: e instanceof Error ? e : new Error(String(e))
  };
}