"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchQueryOutput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _coreHttpBrowser = require("@kbn/core-http-browser");
var _errors = require("../../../common/errors");
var _styles = require("./styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING_MESSAGE = _i18n.i18n.translate('xpack.searchPlayground.viewQuery.queryOutput.loading.message', {
  defaultMessage: 'Fetching...'
});
const ElasticsearchQueryOutput = ({
  queryResponse,
  isError,
  queryError,
  isLoading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const respJSON = (0, _react.useMemo)(() => {
    if (isError) {
      if ((0, _coreHttpBrowser.isHttpFetchError)(queryError)) {
        return queryError !== null && queryError !== void 0 && queryError.body ? JSON.stringify(queryError === null || queryError === void 0 ? void 0 : queryError.body, null, 2) : queryError.message;
      }
      return (0, _errors.getErrorMessage)(queryError);
    }
    return queryResponse ? JSON.stringify(queryResponse.searchResponse, null, 2) : undefined;
  }, [isError, queryError, queryResponse]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    css: _styles.FullHeight,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    css: (0, _styles.QueryViewTitlePanel)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.queryOutput.title",
    defaultMessage: "Query output"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: _styles.PanelFillContainer
  }, !!respJSON ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: "ViewElasticsearchQueryResponse",
    languageId: "json",
    value: isLoading ? LOADING_MESSAGE : respJSON,
    options: {
      automaticLayout: true,
      readOnly: true
    },
    enableFindAction: true,
    fullWidth: true,
    isCopyable: true
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    css: _styles.FullHeight,
    "data-test-subj": "ViewElasticsearchQueryResponseEmptyState"
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.queryOutput.emptyPrompt.body",
    defaultMessage: "Run your query above to view the raw JSON output here."
  }))))));
};
exports.ElasticsearchQueryOutput = ElasticsearchQueryOutput;