"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEmptyUsageTracker = createEmptyUsageTracker;
exports.createUsageTracker = createUsageTracker;
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APP_TRACKER_NAME = 'searchHomepage';
function createUsageTracker(usageCollection) {
  const track = (type, name) => usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter(APP_TRACKER_NAME, type, name);
  return {
    click: eventName => {
      track(_analytics.METRIC_TYPE.CLICK, eventName);
    },
    count: eventName => {
      track(_analytics.METRIC_TYPE.COUNT, eventName);
    },
    load: eventName => {
      track(_analytics.METRIC_TYPE.LOADED, eventName);
    }
  };
}
function createEmptyUsageTracker() {
  return {
    click: _eventName => {},
    count: _eventName => {},
    load: _eventName => {}
  };
}