"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiveDeeperWithElasticsearch = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../common/doc_links");
var _doc_callouts = require("./doc_callouts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DiveDeeperWithElasticsearch = () => {
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.searchHomepage.diveDeeper.title', {
    defaultMessage: 'Dive deeper with Elasticsearch'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: currentBreakpoint === 'xl' ? 'row' : 'column'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "searchLabsSection"
  }, /*#__PURE__*/_react.default.createElement(_doc_callouts.DocCallouts, {
    title: _i18n.i18n.translate('xpack.searchHomepage.searchLabs.title', {
      defaultMessage: 'Elasticsearch Labs'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.searchLabs.description', {
      defaultMessage: 'Explore the latest innovations for advanced search experiences.'
    }),
    buttonHref: _doc_links.docLinks.visitSearchLabs,
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.searchLabs.buttonText', {
      defaultMessage: 'Visit Elasticsearch Labs'
    }),
    dataTestSubj: "searchLabsButton"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "pythonNotebooksSection"
  }, /*#__PURE__*/_react.default.createElement(_doc_callouts.DocCallouts, {
    title: _i18n.i18n.translate('xpack.searchHomepage.pythonNotebooks.title', {
      defaultMessage: 'Python notebooks'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.pythonNotebooks.description', {
      defaultMessage: 'Test features in a virtual environment with executable notebooks.'
    }),
    buttonHref: _doc_links.docLinks.notebooksExamples,
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.pythonNotebooks.buttonText', {
      defaultMessage: 'Open notebooks'
    }),
    dataTestSubj: "openNotebooksButton"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "elasticsearchDocumentationSection"
  }, /*#__PURE__*/_react.default.createElement(_doc_callouts.DocCallouts, {
    title: _i18n.i18n.translate('xpack.searchHomepage.elasticsearchDocs.title', {
      defaultMessage: 'Elasticsearch documentation'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.elasticsearchDocumentation.description', {
      defaultMessage: 'Learn about Elasticsearch APIs, query languages, and common use cases.'
    }),
    buttonHref: _doc_links.docLinks.elasticsearchDocs,
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.elasticsearchDocumentation.buttonText', {
      defaultMessage: 'View documentation'
    }),
    dataTestSubj: "viewDocumentationButton"
  }))));
};
exports.DiveDeeperWithElasticsearch = DiveDeeperWithElasticsearch;