"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sortSchema = _configSchema.schema.arrayOf(_configSchema.schema.string(), {
  maxSize: 2
});
const savedSearchAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  sort: _configSchema.schema.oneOf([sortSchema, _configSchema.schema.arrayOf(sortSchema)]),
  columns: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  description: _configSchema.schema.string(),
  grid: _configSchema.schema.object({
    columns: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
      width: _configSchema.schema.maybe(_configSchema.schema.number())
    })))
  }),
  hideChart: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  isTextBasedQuery: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  usesAdHocDataView: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  kibanaSavedObjectMeta: _configSchema.schema.object({
    searchSourceJSON: _configSchema.schema.string()
  }),
  viewMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('documents'), _configSchema.schema.literal('patterns'), _configSchema.schema.literal('aggregated')])),
  hideAggregatedPreview: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  rowHeight: _configSchema.schema.maybe(_configSchema.schema.number()),
  headerRowHeight: _configSchema.schema.maybe(_configSchema.schema.number()),
  hits: _configSchema.schema.maybe(_configSchema.schema.number()),
  timeRestore: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  timeRange: _configSchema.schema.maybe(_configSchema.schema.object({
    from: _configSchema.schema.string(),
    to: _configSchema.schema.string()
  })),
  refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
    pause: _configSchema.schema.boolean(),
    value: _configSchema.schema.number()
  })),
  rowsPerPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  sampleSize: _configSchema.schema.maybe(_configSchema.schema.number({
    min: _constants.MIN_SAVED_SEARCH_SAMPLE_SIZE,
    max: _constants.MAX_SAVED_SEARCH_SAMPLE_SIZE
  })),
  density: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('compact'), _configSchema.schema.literal('normal'), _configSchema.schema.literal('expanded')])),
  breakdownField: _configSchema.schema.maybe(_configSchema.schema.string()),
  visContext: _configSchema.schema.maybe(_configSchema.schema.oneOf([
  // existing value
  _configSchema.schema.object({
    // unified histogram state
    suggestionType: _configSchema.schema.string(),
    requestData: _configSchema.schema.object({
      dataViewId: _configSchema.schema.maybe(_configSchema.schema.string()),
      timeField: _configSchema.schema.maybe(_configSchema.schema.string()),
      timeInterval: _configSchema.schema.maybe(_configSchema.schema.string()),
      breakdownField: _configSchema.schema.maybe(_configSchema.schema.string())
    }),
    // lens attributes
    attributes: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())
  }),
  // cleared previous value
  _configSchema.schema.object({})])),
  version: _configSchema.schema.maybe(_configSchema.schema.number())
}, {
  unknowns: 'forbid'
});
const savedSearchSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(savedSearchAttributesSchema);
const savedSearchCreateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  id: _contentManagementUtils.createOptionsSchemas.id,
  references: _contentManagementUtils.createOptionsSchemas.references,
  overwrite: _contentManagementUtils.createOptionsSchemas.overwrite
}));
const savedSearchUpdateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  references: _contentManagementUtils.updateOptionsSchema.references
}));
const savedSearchSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}));

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(savedSearchSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: savedSearchCreateOptionsSchema
      },
      data: {
        schema: savedSearchAttributesSchema
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(savedSearchSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      options: {
        schema: savedSearchUpdateOptionsSchema
      },
      data: {
        schema: savedSearchAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: savedSearchSearchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: savedSearchSavedObjectSchema
      }
    }
  }
};