"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedObjectCounts = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSavedObjectCounts = async ({
  types,
  options,
  client
}) => {
  var _body$aggregations, _body$aggregations$ty;
  const body = await client.find({
    ...options,
    type: types,
    perPage: 0,
    aggs: {
      types: {
        terms: {
          field: 'type',
          size: types.length
        }
      }
    }
  });
  const buckets = ((_body$aggregations = body.aggregations) === null || _body$aggregations === void 0 ? void 0 : (_body$aggregations$ty = _body$aggregations.types) === null || _body$aggregations$ty === void 0 ? void 0 : _body$aggregations$ty.buckets) || [];
  const counts = buckets.reduce((memo, bucket) => {
    memo[`${bucket.key}`] = bucket.doc_count;
    return memo;
  }, {});
  return counts;
};
exports.getSavedObjectCounts = getSavedObjectCounts;