"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableStackTraces = EmbeddableStackTraces;
var _react = _interopRequireDefault(require("react"));
var _profiling_embeddable_provider = require("../profiling_embeddable_provider");
var _stack_traces = require("./stack_traces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmbeddableStackTraces({
  type,
  kuery,
  rangeFrom,
  rangeTo,
  onClick,
  onChartBrushEnd,
  ...deps
}) {
  return /*#__PURE__*/_react.default.createElement(_profiling_embeddable_provider.ProfilingEmbeddableProvider, {
    deps: deps
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_stack_traces.StackTraces, {
    type: type,
    kuery: kuery,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    onClick: onClick,
    onChartBrushEnd: onChartBrushEnd
  })));
}