"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComparisonImpactRow = getComparisonImpactRow;
exports.getImpactRows = getImpactRows;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _as_cost = require("../../utils/formatters/as_cost");
var _as_duration = require("../../utils/formatters/as_duration");
var _as_number = require("../../utils/formatters/as_number");
var _as_percentage = require("../../utils/formatters/as_percentage");
var _as_weight = require("../../utils/formatters/as_weight");
var _cpu_label_with_hint = require("../cpu_label_with_hint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getComparisonValue = (value, comparisonValue) => comparisonValue ? `${value} vs ${comparisonValue}` : value;

/**
 * e.g.:
 * label: 'foo',
 * value: 'abc' vs 'xyz'
 */
function getComparisonImpactRow({
  base,
  comparison
}) {
  const baseImpactRows = getImpactRows(base);
  const comparisonImpactRows = comparison ? getImpactRows(comparison) : [];
  return [...(base.rank ? [{
    'data-test-subj': 'rank',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.rank', {
      defaultMessage: 'Rank'
    }),
    value: getComparisonValue(base.rank, comparison === null || comparison === void 0 ? void 0 : comparison.rank)
  }] : []), ...baseImpactRows.map((baseItem, index) => {
    var _comparisonImpactRows;
    const comparisonValue = (_comparisonImpactRows = comparisonImpactRows[index]) === null || _comparisonImpactRows === void 0 ? void 0 : _comparisonImpactRows.value;
    return {
      ...baseItem,
      value: getComparisonValue(baseItem.value, comparisonValue)
    };
  })];
}
function getImpactRows({
  countInclusive,
  countExclusive,
  totalSamples,
  totalSeconds,
  calculateImpactEstimates,
  selfAnnualCO2Kgs,
  totalAnnualCO2Kgs,
  selfAnnualCostUSD,
  totalAnnualCostUSD
}) {
  const {
    selfCPU,
    totalCPU
  } = calculateImpactEstimates({
    countInclusive,
    countExclusive,
    totalSamples,
    totalSeconds
  });
  const annualSecondsRatio = _use_calculate_impact_estimates.ANNUAL_SECONDS / totalSeconds;
  return [{
    'data-test-subj': 'totalCPU',
    label: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "total",
      labelSize: "s",
      iconSize: "s"
    }),
    value: (0, _as_percentage.asPercentage)(totalCPU.percentage)
  }, {
    'data-test-subj': 'selfCPU',
    label: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "self",
      labelSize: "s",
      iconSize: "s"
    }),
    value: (0, _as_percentage.asPercentage)(selfCPU.percentage)
  }, {
    'data-test-subj': 'samples',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.samplesInclusiveLabel', {
      defaultMessage: 'Samples'
    }),
    value: (0, _as_number.asNumber)(countInclusive)
  }, {
    'data-test-subj': 'selfSamples',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.samplesExclusiveLabel', {
      defaultMessage: 'Samples (excl. children)'
    }),
    value: (0, _as_number.asNumber)(countExclusive)
  }, {
    'data-test-subj': 'coreSeconds',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.coreSecondsInclusiveLabel', {
      defaultMessage: 'Core-seconds'
    }),
    value: (0, _as_duration.asDuration)(totalCPU.coreSeconds)
  }, {
    'data-test-subj': 'selfCoreSeconds',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.coreSecondsExclusiveLabel', {
      defaultMessage: 'Core-seconds (excl. children)'
    }),
    value: (0, _as_duration.asDuration)(selfCPU.coreSeconds)
  }, {
    'data-test-subj': 'annualizedCoreSeconds',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCoreSecondsInclusiveLabel', {
      defaultMessage: 'Annualized core-seconds'
    }),
    value: (0, _as_duration.asDuration)(totalCPU.annualizedCoreSeconds)
  }, {
    'data-test-subj': 'annualizedSelfCoreSeconds',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCoreSecondsExclusiveLabel', {
      defaultMessage: 'Annualized core-seconds (excl. children)'
    }),
    value: (0, _as_duration.asDuration)(selfCPU.annualizedCoreSeconds)
  }, {
    'data-test-subj': 'co2Emission',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.co2EmissionInclusiveLabel', {
      defaultMessage: 'CO2 emission'
    }),
    value: (0, _as_weight.asWeight)(totalAnnualCO2Kgs / annualSecondsRatio, 'kgs')
  }, {
    'data-test-subj': 'selfCo2Emission',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.co2EmissionExclusiveLabel', {
      defaultMessage: 'CO2 emission (excl. children)'
    }),
    value: (0, _as_weight.asWeight)(selfAnnualCO2Kgs / annualSecondsRatio, 'kgs')
  }, {
    'data-test-subj': 'annualizedCo2Emission',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCo2InclusiveLabel', {
      defaultMessage: 'Annualized CO2'
    }),
    value: (0, _as_weight.asWeight)(totalAnnualCO2Kgs, 'kgs')
  }, {
    'data-test-subj': 'annualizedSelfCo2Emission',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedCo2ExclusiveLabel', {
      defaultMessage: 'Annualized CO2 (excl. children)'
    }),
    value: (0, _as_weight.asWeight)(selfAnnualCO2Kgs, 'kgs')
  }, {
    'data-test-subj': 'dollarCost',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.dollarCostInclusiveLabel', {
      defaultMessage: 'Dollar cost'
    }),
    value: (0, _as_cost.asCost)(totalAnnualCostUSD / annualSecondsRatio)
  }, {
    'data-test-subj': 'selfDollarCost',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.dollarCostExclusiveLabel', {
      defaultMessage: 'Dollar cost (excl. children)'
    }),
    value: (0, _as_cost.asCost)(selfAnnualCostUSD / annualSecondsRatio)
  }, {
    'data-test-subj': 'annualizedDollarCost',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedDollarCostInclusiveLabel', {
      defaultMessage: 'Annualized dollar cost'
    }),
    value: (0, _as_cost.asCost)(totalAnnualCostUSD)
  }, {
    'data-test-subj': 'annualizedSelfDollarCost',
    label: _i18n.i18n.translate('xpack.profiling.flameGraphInformationWindow.annualizedDollarCostExclusiveLabel', {
      defaultMessage: 'Annualized dollar cost (excl. children)'
    }),
    value: (0, _as_cost.asCost)(selfAnnualCostUSD)
  }];
}