"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSupportedPlatforms = exports.getPlatformIconModule = void 0;
var _lodash = require("lodash");
var _constants = require("./constants");
var _linux = _interopRequireDefault(require("./logos/linux.svg"));
var _windows = _interopRequireDefault(require("./logos/windows.svg"));
var _macos = _interopRequireDefault(require("./logos/macos.svg"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPlatformIconModule = platform => {
  switch (platform) {
    case 'darwin':
      return _macos.default;
    case 'linux':
      return _linux.default;
    case 'windows':
      return _windows.default;
    default:
      return `${platform}`;
  }
};
exports.getPlatformIconModule = getPlatformIconModule;
const getSupportedPlatforms = payload => {
  let platformArray;
  try {
    platformArray = payload === null || payload === void 0 ? void 0 : payload.split(',').map(platformString => platformString.trim());
  } catch (e) {
    return undefined;
  }
  if (!platformArray) return;
  return (0, _lodash.uniq)(platformArray.reduce((acc, nextPlatform) => {
    if (!_constants.SUPPORTED_PLATFORMS.includes(nextPlatform)) {
      if (nextPlatform === 'posix') {
        acc.push(_types.PlatformType.darwin);
        acc.push(_types.PlatformType.linux);
      }
      if (nextPlatform === 'ubuntu') {
        acc.push(_types.PlatformType.linux);
      }
    } else {
      acc.push(nextPlatform);
    }
    return acc;
  }, [])).join(',');
};
exports.getSupportedPlatforms = getSupportedPlatforms;