"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineToolProviders = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a tool provider that combines multiple tool providers.
 *
 * Note: order matters - providers will be checked in the order they are in the list (in case of ID conflict)
 */
const combineToolProviders = (...providers) => {
  const addMeta = (tool, providerId) => {
    var _tool$meta$tags, _tool$meta;
    return {
      ...tool,
      meta: {
        ...tool.meta,
        tags: (_tool$meta$tags = (_tool$meta = tool.meta) === null || _tool$meta === void 0 ? void 0 : _tool$meta.tags) !== null && _tool$meta$tags !== void 0 ? _tool$meta$tags : [],
        providerId
      }
    };
  };
  return {
    has: async options => {
      for (const provider of providers) {
        const {
          toolId,
          providerId
        } = (0, _onechatCommon.toStructuredToolIdentifier)(options.toolId);
        if (providerId === provider.id || providerId === _onechatCommon.unknownToolProviderId) {
          const providerHasTool = await provider.has({
            ...options,
            toolId
          });
          if (providerHasTool) {
            return true;
          }
        }
      }
      return false;
    },
    get: async options => {
      for (const provider of providers) {
        const {
          toolId,
          providerId
        } = (0, _onechatCommon.toStructuredToolIdentifier)(options.toolId);
        if (providerId === provider.id || providerId === _onechatCommon.unknownToolProviderId) {
          const providerHasTool = await provider.has({
            ...options,
            toolId
          });
          if (providerHasTool) {
            const tool = await provider.get({
              ...options,
              toolId
            });
            return addMeta(tool, provider.id);
          }
        }
      }
      throw new Error(`Tool with id ${options.toolId} not found`);
    },
    list: async options => {
      const tools = [];
      for (const provider of providers) {
        const providerTools = await provider.list(options);
        for (const tool of providerTools) {
          tools.push(addMeta(tool, provider.id));
        }
      }
      return tools;
    }
  };
};
exports.combineToolProviders = combineToolProviders;