"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roundToLangchain = exports.createToolCallMessages = exports.conversationToLangchainMessages = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _messages = require("@langchain/core/messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts a conversation to langchain format
 */
const conversationToLangchainMessages = ({
  previousRounds,
  nextInput,
  ignoreSteps = false
}) => {
  const messages = [];
  for (const round of previousRounds) {
    messages.push(...roundToLangchain(round, {
      ignoreSteps
    }));
  }
  messages.push(createUserMessage({
    content: nextInput.message
  }));
  return messages;
};
exports.conversationToLangchainMessages = conversationToLangchainMessages;
const roundToLangchain = (round, {
  ignoreSteps = false
} = {}) => {
  const messages = [];

  // user message
  messages.push(createUserMessage({
    content: round.userInput.message
  }));

  // steps
  if (!ignoreSteps) {
    for (const step of round.steps) {
      if ((0, _onechatCommon.isToolCallStep)(step)) {
        messages.push(...createToolCallMessages(step));
      }
    }
  }

  // assistant response
  messages.push(createAssistantMessage({
    content: round.assistantResponse.message
  }));
  return messages;
};
exports.roundToLangchain = roundToLangchain;
const createUserMessage = ({
  content
}) => {
  return new _messages.HumanMessage({
    content
  });
};
const createAssistantMessage = ({
  content
}) => {
  return new _messages.AIMessage({
    content
  });
};
const createToolCallMessages = toolCall => {
  const toolCallMessage = new _messages.AIMessage({
    content: '',
    tool_calls: [{
      id: toolCall.toolCallId,
      name: toolCall.toolId.toolId,
      args: toolCall.args,
      type: 'tool_call'
    }]
  });
  const toolResultMessage = new _messages.ToolMessage({
    tool_call_id: toolCall.toolCallId,
    content: toolCall.result
  });
  return [toolCallMessage, toolResultMessage];
};
exports.createToolCallMessages = createToolCallMessages;