"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseActions = void 0;
var _react = require("react");
var _common = require("@kbn/cases-plugin/common");
var _kibana_react = require("../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCaseActions = ({
  alerts,
  refresh
}) => {
  const services = (0, _kibana_react.useKibana)().services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    helpers: {
      getRuleIdFromEvent
    },
    hooks: {
      useCasesAddToNewCaseFlyout,
      useCasesAddToExistingCaseModal
    }
  } = services.cases; // Cases is guaranteed to be defined in Observability

  const onSuccess = (0, _react.useCallback)(() => {
    refresh === null || refresh === void 0 ? void 0 : refresh();
  }, [refresh]);
  const selectCaseModal = useCasesAddToExistingCaseModal({
    onSuccess
  });
  function getCaseAttachments() {
    return alerts.map(alert => {
      var _alert$_id, _alert$_index, _alert$_id2, _alert$_index2, _Object$entries$reduc;
      return {
        alertId: (_alert$_id = alert === null || alert === void 0 ? void 0 : alert._id) !== null && _alert$_id !== void 0 ? _alert$_id : '',
        index: (_alert$_index = alert === null || alert === void 0 ? void 0 : alert._index) !== null && _alert$_index !== void 0 ? _alert$_index : '',
        type: _common.AttachmentType.alert,
        rule: getRuleIdFromEvent({
          ecs: {
            _id: (_alert$_id2 = alert === null || alert === void 0 ? void 0 : alert._id) !== null && _alert$_id2 !== void 0 ? _alert$_id2 : '',
            _index: (_alert$_index2 = alert === null || alert === void 0 ? void 0 : alert._index) !== null && _alert$_index2 !== void 0 ? _alert$_index2 : ''
          },
          data: (_Object$entries$reduc = Object.entries(alert !== null && alert !== void 0 ? alert : {}).reduce((acc, [field, value]) => [...acc, {
            field,
            value: value
          }], [])) !== null && _Object$entries$reduc !== void 0 ? _Object$entries$reduc : []
        })
      };
    });
  }
  const createCaseFlyout = useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const closeActionsPopover = () => {
    setIsPopoverOpen(false);
  };
  const handleAddToNewCaseClick = () => {
    createCaseFlyout.open({
      attachments: getCaseAttachments()
    });
    closeActionsPopover();
  };
  const handleAddToExistingCaseClick = () => {
    selectCaseModal.open({
      getAttachments: () => getCaseAttachments()
    });
    closeActionsPopover();
  };
  return {
    isPopoverOpen,
    setIsPopoverOpen,
    handleAddToExistingCaseClick,
    handleAddToNewCaseClick
  };
};
exports.useCaseActions = useCaseActions;