"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextualInsightMessages = getContextualInsightMessages;
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getContextualInsightMessages({
  message,
  instructions
}) {
  return [{
    '@timestamp': new Date().toISOString(),
    message: {
      role: _common.MessageRole.User,
      content: message
    }
  }, {
    '@timestamp': new Date().toISOString(),
    message: {
      role: _common.MessageRole.Assistant,
      function_call: {
        name: 'get_contextual_insight_instructions',
        trigger: _common.MessageRole.Assistant,
        arguments: JSON.stringify({})
      }
    }
  }, {
    '@timestamp': new Date().toISOString(),
    message: {
      role: _common.MessageRole.User,
      content: JSON.stringify({
        instructions
      }),
      name: 'get_contextual_insight_instructions'
    }
  }];
}