/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.ml_bundle_jsonpfunction=self.ml_bundle_jsonpfunction||[]).push([[3223],{14595:(e,t,a)=>{function s(e,t,a){return(a?e.filter((e=>{const t=e.entityName,s=e.entityValue;return a.some((e=>e.fieldName===t&&e.fieldValue===s))})):e).reduce(((e,a)=>{if(!e)return a;const s=Math.abs(t-e.source.timestamp);return Math.abs(t-a.source.timestamp)<s?a:e}),void 0)}a.d(t,{O:()=>s})},53696:(e,t,a)=>{a.d(t,{K:()=>P,L:()=>ForecastingModal});var s=a(68915),o=a(30770),i=a(84286),r=a.n(i),n=a(81319),l=a(75008),c=a(20409),u=a(43627),d=a(64189),m=a(99280);const h="error",p="warning";var f=a(62106),g=a(3185),x=a(70452),v=a.n(x),b=a(96791);function S({message:e,status:t,...a}){return(0,b.jsx)(n.EuiCallOut,(0,g.default)({size:"s"},function(e,t){switch(t){case h:return{title:e,iconType:"cross",color:"danger"};case p:return{title:e,iconType:"warning",color:"warning"};case"success":return{title:e,iconType:"check",color:"success"};case"info":return{title:e,iconType:"info",color:"primary"}}}(e,t),a))}var y=a(67140),M=a(23120),F=a(42100),E=a(75879);function w(e){return[{field:"forecast_create_timestamp",name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.createdColumnName",{defaultMessage:"Created"}),dataType:"date",render:e=>(0,F.v_)(e),sortable:!0},{field:"forecast_start_timestamp",name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.fromColumnName",{defaultMessage:"From"}),dataType:"date",render:e=>(0,F.v_)(e),sortable:!0},{field:"forecast_end_timestamp",name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.toColumnName",{defaultMessage:"To"}),dataType:"date",render:e=>(0,F.v_)(e),sortable:!0},{name:l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.viewColumnName",{defaultMessage:"View"}),width:"60px",render:t=>{const a=l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastsList.viewForecastAriaLabel",{defaultMessage:"View forecast created at {createdDate}",values:{createdDate:(0,F.v_)(t.forecast_create_timestamp)}});return(0,b.jsx)(n.EuiButtonIcon,{onClick:()=>e(t.forecast_id),iconType:"singleMetricViewer","aria-label":a})}}]}function _({forecasts:e,viewForecast:t,selectedForecastId:a}){const{euiTheme:s}=(0,n.useEuiTheme)();return(0,b.jsx)(n.EuiText,null,(0,b.jsx)("h3",{"aria-describedby":"ml_aria_description_forecasting_modal_view_list"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastsList.previousForecastsTitle",defaultMessage:"Previous forecasts"})," ",(0,b.jsx)(n.EuiIconTip,{size:"s",type:"question",content:(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastsList.listsOfFiveRecentlyRunForecastsTooltip",defaultMessage:"Lists a maximum of five of the most recently run forecasts."})})),(0,b.jsx)(n.EuiInMemoryTable,{items:e,columns:w(t),pagination:!1,"data-test-subj":"mlModalForecastTable",rowProps:e=>({"data-test-subj":`mlForecastsListRow row-${e.rowId}`,...e.forecast_id===a?{style:{backgroundColor:`${s.colors.backgroundBasePrimary}`}}:{}})}))}_.propType={forecasts:v().array,viewForecast:v().func.isRequired,selectedForecastId:v().string};const k=-1,T=-10;function j({state:e}){return 0===e?(0,b.jsx)(n.EuiLoadingSpinner,{size:"m"}):1===e?(0,b.jsx)(n.EuiIcon,{type:"check",size:"m",color:"primary"}):e===T?(0,b.jsx)(n.EuiIcon,{type:"cross",size:"m",color:"danger"}):void 0}function A({forecastProgress:e,jobOpeningState:t,jobClosingState:a}){return(0,b.jsx)("div",null,t!==k&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(n.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiText,{size:"m"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.openingJobTitle",defaultMessage:"Opening job…"}))),(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(j,{state:t}))),(0,b.jsx)(n.EuiSpacer,{size:"s"})),e!==k&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(n.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiText,{size:"m"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.runningForecastTitle",defaultMessage:"Running forecast…"}))),e>=0&&(0,b.jsx)(n.EuiFlexItem,null,(0,b.jsx)(n.EuiToolTip,{position:"top",content:e+"%"},(0,b.jsx)(n.EuiProgress,{size:"l",value:e,max:100}))),e===T&&(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(j,{state:T}))),(0,b.jsx)(n.EuiSpacer,{size:"s"})),a!==k&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(n.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiText,{size:"m"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.closingJobTitle",defaultMessage:"Closing job…"}))),(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(j,{state:a})))))}A.propType={forecastProgress:v().number,jobOpeningState:v().number,jobClosingState:v().number};var C=a(26192);function I({job:e,mlNodesAvailable:t,newForecastDuration:a,isNewForecastDurationValid:s,newForecastDurationErrors:o,neverExpires:i,onNeverExpiresChange:r,onNewForecastDurationChange:c,runForecast:u,isForecastRequested:d,forecastProgress:h,jobOpeningState:p,jobClosingState:f,jobState:g}){const x=function(e,t,a,s){return!1===a?{isDisabled:!0,isDisabledToolTipText:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.noMLNodesAvailableTooltip",{defaultMessage:"There are no ML nodes available."})}:!1===(0,C.checkPermission)("canForecastJob")?{isDisabled:!0,isDisabledToolTipText:(0,C.createPermissionFailureMessage)("canForecastJob")}:s!==m.EW.OPENED&&s!==m.EW.CLOSED?{isDisabled:!0,isDisabledToolTipText:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.forecastsCanNotBeRunOnJobsTooltip",{defaultMessage:"Forecasts cannot be run on {jobState} jobs",values:{jobState:s}})}:{isDisabled:t}}(0,d,t,g),v=(0,b.jsx)(n.EuiFieldText,{name:"forecastDuration",value:a,disabled:x.isDisabled,isInvalid:!s,onChange:c,fullWidth:!0}),S=(0,b.jsx)(n.EuiButton,{onClick:u,isDisabled:x.isDisabled||!s,"data-test-subj":"mlModalForecastButtonRun"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.runButtonLabel",defaultMessage:"Run"}));return(0,b.jsx)("div",null,(0,b.jsx)(n.EuiText,null,(0,b.jsx)("h3",null,(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.runNewForecastTitle",defaultMessage:"Run a new forecast"}))),(0,b.jsx)(n.EuiSpacer,{size:"s"}),(0,b.jsx)(n.EuiForm,null,(0,b.jsx)(n.EuiFlexGroup,{direction:"column"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiFormRow,{label:(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.durationLabel",defaultMessage:"Duration"}),fullWidth:!0,isInvalid:!s,error:o,helpText:(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.runControls.forecastMaximumLengthHelpText",defaultMessage:"Length of forecast, up to a maximum of {maximumForecastDurationDays} days. Use s for seconds, m for minutes, h for hours, d for days, w for weeks.",values:{maximumForecastDurationDays:P}})},void 0===x.isDisabledToolTipText?v:(0,b.jsx)(n.EuiToolTip,{position:"right",content:x.isDisabledToolTipText},v))),(0,b.jsx)(n.EuiFlexItem,null,(0,b.jsx)(n.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiFormRow,{helpText:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.neverExpireHelpText",{defaultMessage:"If disabled, forecasts will be retained for 14 days."})},(0,b.jsx)(n.EuiSwitch,{"data-test-subj":"mlModalForecastNeverExpireSwitch",disabled:x.isDisabled,label:l.i18n.translate("xpack.ml.timeSeriesExplorer.runControls.neverExpireLabel",{defaultMessage:"Never expire"}),checked:i,onChange:r}))),(0,b.jsx)(n.EuiFlexItem,{grow:!1},(0,b.jsx)(n.EuiFormRow,{hasEmptyLabelSpace:!0},void 0===x.isDisabledToolTipText?S:(0,b.jsx)(n.EuiToolTip,{position:"left",content:x.isDisabledToolTipText},S))))))),(0,b.jsx)(n.EuiSpacer,{size:"s"}),!0===d&&(0,b.jsx)(A,{forecastProgress:h,jobOpeningState:p,jobClosingState:f}))}I.propType={job:v().object,newForecastDuration:v().string,isNewForecastDurationValid:v().bool,newForecastDurationErrors:v().array,neverExpires:v().bool.isRequired,onNewForecastDurationChange:v().func.isRequired,onNeverExpiresChange:v().func.isRequired,runForecast:v().func.isRequired,isForecastRequested:v().bool,forecastProgress:v().number,jobOpeningState:v().number,jobClosingState:v().number};var D=a(43721);function N(e){const t=(0,n.useGeneratedHtmlId)(),[a,s]=(0,i.useState)(!1),{services:{mlServices:{mlApi:o}}}=(0,y.hk)();return(0,i.useEffect)((function(){(0,M.JS)(o).then((({count:e,lazyNodeCount:t})=>{s(0!==e||0!==t)})).catch(D.error)}),[o]),(0,b.jsx)(n.EuiModal,{"aria-labelledby":t,onClose:e.close,maxWidth:860,"data-test-subj":"mlModalForecast"},(0,b.jsx)(n.EuiModalHeader,null,(0,b.jsx)(n.EuiModalHeaderTitle,{id:t},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.forecastingTitle",defaultMessage:"Forecasting"}))),(0,b.jsx)(n.EuiModalBody,null,e.messages.map(((e,t)=>(0,b.jsx)(r().Fragment,{key:t},(0,b.jsx)(S,e),(0,b.jsx)(n.EuiSpacer,{size:"m"})))),e.forecasts.length>0&&(0,b.jsx)(r().Fragment,null,(0,b.jsx)(_,{forecasts:e.forecasts,viewForecast:e.viewForecast,selectedForecastId:e.selectedForecastId}),(0,b.jsx)(n.EuiSpacer,null)),(0,b.jsx)(I,(0,g.default)({},e,{mlNodesAvailable:a,jobState:e.jobState}))),(0,b.jsx)(n.EuiModalFooter,null,(0,b.jsx)(n.EuiButtonEmpty,{onClick:e.close,size:"s","data-test-subj":"mlModalForecastButtonClose"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.closeButtonLabel",defaultMessage:"Close"}))))}N.propType={job:v().object,forecasts:v().array,close:v().func.isRequired,viewForecast:v().func.isRequired,runForecast:v().func.isRequired,newForecastDuration:v().string,isNewForecastDurationValid:v().bool,newForecastDurationErrors:v().array,onNewForecastDurationChange:v().func.isRequired,isForecastRequested:v().bool,forecastProgress:v().number,jobOpeningState:v().number,jobClosingState:v().number,messages:v().array,selectedForecastId:v().string};var O=a(84315);const R=({isDisabled:e,onClick:t,mode:a="full"})=>{const s="full"===a?n.EuiButton:n.EuiButtonEmpty;return(0,b.jsx)(s,{color:"full"===a?"text":"primary",onClick:t,isDisabled:e,"data-test-subj":"mlSingleMetricViewerButtonForecast"},(0,b.jsx)(E.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.forecastingModal.forecastButtonLabel",defaultMessage:"Forecast"}))};var B=a(43721);const P=3650,L={term:{forecast_status:m.QX.FINISHED}},z="6.1.0",V=864e5*P,W=12e4;function Y(){return{isModalVisible:!1,previousForecasts:[],isForecastRequested:!1,forecastProgress:k,jobOpeningState:k,jobClosingState:k,newForecastDuration:"1d",isNewForecastDurationValid:!0,newForecastDurationErrors:[],neverExpires:!1,messages:[]}}class ForecastingModal extends i.Component{constructor(e){super(e),(0,s.default)(this,"addMessage",((e,t,a=!1)=>{const s={message:e,status:t};this.setState((e=>({messages:a?[s]:[...e.messages,s]})))})),(0,s.default)(this,"viewForecast",(e=>{if(this.props.setForecastId(e),void 0!==this.props.onForecastComplete&&this.state.previousForecasts.length>0){const t=this.state.previousForecasts.find((t=>e===t.forecast_id));this.props.onForecastComplete(t.forecast_end_timestamp)}this.closeModal()})),(0,s.default)(this,"onNeverExpiresChange",(e=>{this.setState({neverExpires:e.target.checked})})),(0,s.default)(this,"onNewForecastDurationChange",(e=>{const t=[];let a=!0;const s=(0,d.P)(e.target.value);null===s?(a=!1,t.push(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.invalidDurationFormatErrorMessage",{defaultMessage:"Invalid duration format"}))):s.asMilliseconds()>V?(a=!1,t.push(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastDurationMustNotBeGreaterThanMaximumErrorMessage",{defaultMessage:"Forecast duration must not be greater than {maximumForecastDurationDays} days",values:{maximumForecastDurationDays:P}}))):0===s.asMilliseconds()&&(a=!1,t.push(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastDurationMustNotBeZeroErrorMessage",{defaultMessage:"Forecast duration must not be zero"}))),this.setState({newForecastDuration:e.target.value,isNewForecastDurationValid:a,newForecastDurationErrors:t})})),(0,s.default)(this,"checkJobStateAndRunForecast",(()=>{this.setState({isForecastRequested:!0,messages:[]}),this.props.jobState===m.EW.CLOSED||this.props.job.state===m.EW.CLOSED?this.openJobAndRunForecast():this.runForecast(!1)})),(0,s.default)(this,"openJobAndRunForecast",(()=>{this.setState({jobOpeningState:0}),this.context.services.mlServices.mlApi.openJob({jobId:this.props.job.job_id}).then((()=>{this.setState({jobOpeningState:1}),this.runForecast(!0)})).catch((e=>{B.log("Time series forecast modal - could not open job:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithOpeningJobBeforeRunningForecastErrorMessage",{defaultMessage:"Error opening job before running forecast"}),h),this.setState({jobOpeningState:T})}))})),(0,s.default)(this,"runForecastErrorHandler",((e,t)=>{this.setState({forecastProgress:T}),B.log("Time series forecast modal - error running forecast:",e);const a=e?(0,u.P)(e):void 0;a&&a.length>0?this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorRunningForecastMessage",{defaultMessage:"An error has occurred running the forecast: {errorMessage}",values:{errorMessage:a}}),h,!0):this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.unexpectedResponseFromRunningForecastErrorMessage",{defaultMessage:"Unexpected response from running forecast. The request may have failed."}),h,!0),!0===t&&(this.setState({jobClosingState:0}),this.context.services.mlServices.mlApi.closeJob({jobId:this.props.job.job_id}).then((()=>{this.setState({jobClosingState:1})})).catch((e=>{B.log("Time series forecast modal - could not close job:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithClosingJobErrorMessage",{defaultMessage:"Error closing job"}),h),this.setState({jobClosingState:T})})))})),(0,s.default)(this,"runForecast",(e=>{this.setState({forecastProgress:0});const t=(0,d.P)(this.state.newForecastDuration).asSeconds();this.mlForecastService.runForecast(this.props.job.job_id,`${t}s`,this.state.neverExpires).then((t=>{void 0!==t.forecast_id?this.waitForForecastResults(t.forecast_id,e):this.runForecastErrorHandler(t,e)})).catch((t=>this.runForecastErrorHandler(t,e)))})),(0,s.default)(this,"waitForForecastResults",((e,t)=>{let a=0,s=0;this.forecastChecker=setInterval((()=>{this.mlForecastService.getForecastRequestStats(this.props.job,e).then((i=>{const r=(0,o.get)(i,["stats","forecast_progress"],a),n=(0,o.get)(i,["stats","forecast_status"]);r>a&&this.setState({forecastProgress:Math.round(100*r)});let c=(0,o.get)(i,["stats","forecast_messages"],[]);c=c.map((e=>({message:e,status:p}))),this.setState({messages:c}),n===m.QX.FINISHED?(clearInterval(this.forecastChecker),void 0!==this.props.onForecastComplete&&this.props.onForecastComplete(i.stats.forecast_end_timestamp),!0===t?(this.setState({jobClosingState:0}),this.context.services.mlServices.mlApi.closeJob({jobId:this.props.job.job_id}).then((()=>{this.setState({jobClosingState:1}),this.props.setForecastId(e),this.closeAfterRunningForecast()})).catch((t=>{B.log("Time series forecast modal - could not close job:",t),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithClosingJobAfterRunningForecastErrorMessage",{defaultMessage:"Error closing job after running forecast"}),h),this.setState({jobClosingState:T}),this.props.setForecastId(e)}))):(this.props.setForecastId(e),this.closeAfterRunningForecast())):r===a?(s+=250,s>W&&(B.log("Forecast request has not progressed for 120000ms. Cancelling check."),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.noProgressReportedForNewForecastErrorMessage",{defaultMessage:"No progress reported for the new forecast for {WarnNoProgressMs}ms.An error may have occurred whilst running the forecast.",values:{WarnNoProgressMs:W}}),h),this.props.setForecastId(e),this.setState({forecastProgress:T}),clearInterval(this.forecastChecker))):(r>a&&(a=r),s=0)})).catch((e=>{B.log("Time series forecast modal - error loading stats of forecast from elasticsearch:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithLoadingStatsOfRunningForecastErrorMessage",{defaultMessage:"Error loading stats of running forecast."}),h),this.setState({forecastProgress:T}),clearInterval(this.forecastChecker)}))}),250)})),(0,s.default)(this,"openModal",(()=>{const{job:e,entities:t,earliestRecordTimestamp:a,latestRecordTimestamp:s}=this.props;if("object"==typeof e){const{timefilter:o}=this.context.services.data.query.timefilter,i=o.getActiveBounds();this.mlForecastService.getForecastsSummary(e,L,i.min.valueOf(),5).then((e=>{this.setState({previousForecasts:e.forecasts})})).catch((e=>{B.log("Time series forecast modal - error obtaining forecasts summary:",e),this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.errorWithObtainingListOfPreviousForecastsErrorMessage",{defaultMessage:"Error obtaining list of previous forecasts"}),h)}));const r=t.map((e=>e.fieldName));r.length>0&&this.context.services.mlServices.mlApi.getCardinalityOfFields({index:e.datafeed_config.indices,fieldNames:r,query:e.datafeed_config.query,timeFieldName:e.data_description.time_field,earliestMs:a,latestMs:s}).then((e=>{let t=1;Object.values(e).forEach((e=>{t*=e})),t>100&&this.addMessage(l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.dataContainsMorePartitionsMessage",{defaultMessage:"Note that this data contains more than {warnNumPartitions} partitions so running a forecast may take a long time and consume a high amount of resource",values:{warnNumPartitions:100}}),p)})).catch((e=>{B.log("Time series forecast modal - error obtaining cardinality of fields:",e)})),this.setState({isModalVisible:!0})}})),(0,s.default)(this,"closeAfterRunningForecast",(()=>{0===this.state.messages.length&&setTimeout((()=>{this.closeModal()}),1e3)})),(0,s.default)(this,"closeModal",(()=>{null!==this.forecastChecker&&clearInterval(this.forecastChecker),this.setState(Y())})),this.state=Y(),this.forecastChecker=null,this.mlForecastService}componentDidMount(){this.mlForecastService=(0,O.P)(this.context.services.mlServices.mlApi)}render(){let e=!1,t=null;const{job:a}=this.props;void 0!==a&&(void 0!==a.analysis_config.detectors[this.props.detectorIndex].over_field_name?(e=!0,t=l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastingNotAvailableForPopulationDetectorsMessage",{defaultMessage:"Forecasting is not available for population detectors with an over field"})):!1===(0,f.KZ)(a,z)&&(e=!0,t=l.i18n.translate("xpack.ml.timeSeriesExplorer.forecastingModal.forecastingOnlyAvailableForJobsCreatedInSpecifiedVersionMessage",{defaultMessage:"Forecasting is only available for jobs created in version {minVersion} or later",values:{minVersion:z}})));const s=(0,b.jsx)(R,{onClick:this.openModal,isDisabled:e,mode:this.props.buttonMode});return(0,b.jsx)("div",null,e?(0,b.jsx)(n.EuiToolTip,{position:"left",content:t},s):s,this.state.isModalVisible&&(0,b.jsx)(N,{jobState:this.props.jobState,job:this.props.job,forecasts:this.state.previousForecasts,close:this.closeModal,viewForecast:this.viewForecast,runForecast:this.checkJobStateAndRunForecast,newForecastDuration:this.state.newForecastDuration,onNewForecastDurationChange:this.onNewForecastDurationChange,onNeverExpiresChange:this.onNeverExpiresChange,neverExpires:this.state.neverExpires,isNewForecastDurationValid:this.state.isNewForecastDurationValid,newForecastDurationErrors:this.state.newForecastDurationErrors,isForecastRequested:this.state.isForecastRequested,forecastProgress:this.state.forecastProgress,jobOpeningState:this.state.jobOpeningState,jobClosingState:this.state.jobClosingState,messages:this.state.messages,selectedForecastId:this.props.selectedForecastId}))}}(0,s.default)(ForecastingModal,"contextType",c.context)},80833:(e,t,a)=>{a.d(t,{Z:()=>ee});var s=a(3185),o=a(84286),i=a.n(o),r=a(75008),n=a(43627),l=a(14651),c=a(68915),u=a(77880),d=a(30770),m=a(47935),h=a.n(m),p=a(51783),f=a.n(p),g=a(81319),x=a(73601),v=a(37110),b=a(60203),S=a(74923),y=a(42100),M=a(20409),F=a(14595),E=a(56478),w=a(17404),_=a(28419),k=a(24418);function T(e,t,a,s){this.contextGroup=e,this.data=t,this.drawBounds=a,this.swimlaneHeight=s,this.mask=this.contextGroup.append("g").attr("class","mask"),this.leftGroup=this.mask.append("g").attr("class","left-mask"),this.rightGroup=this.mask.append("g").attr("class","right-mask"),this.leftPolygon=this.leftGroup.append("polygon"),this.rightPolygon=this.rightGroup.append("polygon"),!0===this.drawBounds&&(this.leftGroup.append("path").attr("class","left area bounds"),this.rightGroup.append("path").attr("class","right area bounds")),this.leftGroup.append("path").attr("class","left values-line"),this.rightGroup.append("path").attr("class","right values-line"),this._x=null,this._y=null}T.prototype.style=function(e,t){return this.leftGroup.style(e,t),this.rightGroup.style(e,t),this},T.prototype.x=function(e){return null==e?this._x:(this._x=e,this)},T.prototype.y=function(e){return null==e?this._y:(this._y=e,this)},T.prototype.redraw=function(){const e=this._y.domain(),t=e[0],a=e[1],s=this._x.domain(),o=s[0],i=s[1],r=this,n=this.data.filter((function(e){return e.date<r.from})),l=this.data.filter((function(e){return e.date>r.to}));if(!0===this.drawBounds){const e=h().svg.area().x((function(e){return r._x(e.date)||1})).y0((function(e){return r._y(Math.min(a,Math.max(e.lower,t)))})).y1((function(e){return r._y(Math.max(t,Math.min(e.upper,a)))})).defined((e=>null!==e.lower&&null!==e.upper));this.leftGroup.select(".left.area.bounds").attr("d",e(n)),this.rightGroup.select(".right.area.bounds").attr("d",e(l))}const c=h().svg.line().x((function(e){return r._x(e.date)})).y((function(e){return r._y(e.value)})).defined((e=>null!==e.value));this.leftGroup.select(".left.values-line").attr("d",c(n)),(0,w.lj)(n,this.leftGroup,c,1),this.rightGroup.select(".right.values-line").attr("d",c(l)),(0,w.lj)(l,this.rightGroup,c,1);const u=this._x(o),d=this._y(t)+this.swimlaneHeight,m=this._x(this.from),p=this._x(this.to),f=this._y(t)+this.swimlaneHeight,g=this._x(i);return this.leftPolygon.attr("points",u+","+d+"  "+m+","+d+"  "+m+",0  "+u+",0"),this.rightPolygon.attr("points",p+","+f+"  "+g+","+f+"  "+g+",0  "+p+",0"),this},T.prototype.reveal=function(e){return this.from=e[0],this.to=e[1],this.redraw(),this};var j=a(90081),A=a(21069),C=a(18422);const I="mlAnnotationMask";function D(){const{annotationUpdatesService:e}=this.props,t=this.focusXScale,a=h().svg.brush().x(t).on("brushend",function(){const{selectedJob:t}=this.props,s=a.extent(),o=s[0].getTime(),i=s[1].getTime();if(o===i)return void e.setValue(null);const r={timestamp:o,end_timestamp:i,annotation:"",job_id:t.job_id,type:C.BQ.ANNOTATION};e.setValue(r)}.bind(this));return a}function N(e){const t={};return e.forEach(((a,s)=>{if(void 0!==a.key){const o=e.filter(((e,t)=>t<s));t[a.key]=o.reduce(((e,s)=>void 0===a.end_timestamp||void 0===s.end_timestamp||void 0===s.key||s.timestamp<a.timestamp&&s.end_timestamp<a.timestamp||s.timestamp>a.end_timestamp&&s.end_timestamp>a.end_timestamp?e:t[s.key]+1),0)}})),t}function O(e){h().selectAll(".ml-annotation").each((function(t){const a=h().select(this);t._id===e._id?a.selectAll(".ml-annotation__rect").classed("ml-annotation__rect--highlight",!0):(a.selectAll(".ml-annotation__text-rect").classed("ml-annotation__text-rect--blur",!0),a.selectAll(".ml-annotation__text").classed("ml-annotation__text--blur",!0),a.selectAll(".ml-annotation__rect").classed("ml-annotation__rect--blur",!0))}))}function R(){h().selectAll(".ml-annotation").each((function(){const e=h().select(this);e.selectAll(".ml-annotation__text-rect").classed("ml-annotation__text-rect--blur",!1),e.selectAll(".ml-annotation__rect").classed("ml-annotation__rect--highlight",!1).classed("ml-annotation__rect--blur",!1),e.selectAll(".ml-annotation__text").classed("ml-annotation__text--blur",!1)}))}var B=a(8414),P=a(72762),L=a(74494),z=a(96791);const V=350,W=25,Y=310,G=335,H=25,U=w.nD+4,X={top:10,right:10,bottom:15,left:40},J=[{duration:f().duration(1,"h"),label:"1h"},{duration:f().duration(12,"h"),label:"12h"},{duration:f().duration(1,"d"),label:"1d"},{duration:f().duration(1,"w"),label:"1w"},{duration:f().duration(2,"w"),label:"2w"},{duration:f().duration(1,"M"),label:"1M"}];function $(e){const t=e<V?V:e,a=Math.round(.634*t);return{focusChartHeight:a,focusHeight:W+a}}class TimeseriesChartIntl extends o.Component{constructor(e,t){super(e),(0,c.default)(this,"getTimeBuckets",void 0),(0,c.default)(this,"mlTimeSeriesExplorer",void 0),(0,c.default)(this,"rowMouseenterSubscriber",null),(0,c.default)(this,"rowMouseleaveSubscriber",null),(0,c.default)(this,"contextChartInitialized",!1),(0,c.default)(this,"drawContextBrush",(e=>{const{contextChartSelected:t}=this.props,a=this.brush,s=this.contextXScale,o=this.mask;a.x(s).on("brush",u).on("brushend",(function(){const e=a.empty()?s.domain():a.extent(),o=e[0].getTime(),i=e[1].getTime();void 0!==c.selectedBounds&&c.selectedBounds.min.valueOf()===o&&c.selectedBounds.max.valueOf()===i||(c.selectedBounds={min:f()(o),max:f()(i)},t({from:e[0],to:e[1]}))})),e.append("g").attr("class","x brush").call(a).selectAll("rect").attr("y",-1).attr("height",91).attr("width",this.vizWidth);const i=a.extent();e.selectAll(".w rect").attr("x",-10).attr("width",10),e.selectAll(".e rect").attr("transform",null).attr("width",10);const r=e.append("rect").attr("class","top-border").attr("y",-2).attr("height",3),n=e.append("foreignObject").attr("width",10).attr("height",90).attr("class","brush-handle").attr("x",s(i[0])-10).html('\n        <div class="brush-handle-inner brush-handle-inner-left" style="padding-top: 27px">\n          <svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="6" height="9">\n            <polygon points="5,0 5,8 0,4" />\n          </svg>\n        </div>'),l=e.append("foreignObject").attr("width",10).attr("height",90).attr("class","brush-handle").attr("x",s(i[1])+0).html('\n        <div class="brush-handle-inner brush-handle-inner-right" style="padding-top: 27px">\n          <svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="6" height="9">\n            <polygon points="0,0 0,8 5,4" />\n          </svg>\n        </div>'),c=this;function u(){const e=a.extent();o.reveal(e),n.attr("x",s(e[0])-10),l.attr("x",s(e[1])+0),r.attr("x",s(e[0])+1);const t=Math.max(0,s(e[1])-s(e[0])-2);r.attr("width",t);const i=a.empty();h().select(c.rootNode).selectAll(".brush-handle").style("visibility",i?"hidden":"visible")}u()})),(0,c.default)(this,"drawSwimlane",((e,t,a)=>{const{contextAggregationInterval:s,swimlaneData:o}=this.props,i=o;if(void 0===i)return;const r=this.calculateContextXAxisDomain(),n=h().time.scale().range([0,t]).domain(r),l=h().scale.linear().range([a,0]).domain([0,a]),c=h().svg.axis().scale(n).orient("bottom").innerTickSize(-a).outerTickSize(0),u=h().svg.axis().scale(l).orient("left").tickValues(l.domain()).innerTickSize(-t).outerTickSize(0),d=e.append("g");d.append("g").attr("class","x axis").attr("transform","translate(0,"+a+")").call(c),d.append("g").attr("class","y axis").call(u);const m=r[0].getTime();let p=t/((r[1].getTime()-m)/s.asMilliseconds());p<1&&(p=1),e.append("g").attr("class","swimlane-cells").selectAll("rect").data(i).enter().append("rect").attr("x",(e=>n(e.date))).attr("y",0).attr("rx",0).attr("ry",0).attr("class",(e=>e.score>0?"swimlane-cell":"swimlane-cell-hidden")).attr("width",p).attr("height",a).style("fill",(e=>this.props.anomalyColorScale(e.score)))})),(0,c.default)(this,"calculateContextXAxisDomain",(()=>{const{bounds:e,contextAggregationInterval:t,swimlaneData:a}=this.props;let s=e.min.valueOf();void 0!==a&&a.length>0&&(s=Math.min(a[0].date.getTime(),e.min.valueOf()));const o=t.asMilliseconds(),i=Math.floor(s/o)*o,r=Math.ceil(e.max.valueOf()/o)*o;return[new Date(i),new Date(r)]})),(0,c.default)(this,"setContextBrushExtent",((e,t)=>{const a=h().select(this.rootNode),s=this.brush,o=s.extent(),i=[e,t];s.extent(i),s(a.select(".brush")),i[0].getTime()===o[0].getTime()&&i[1].getTime()===o[1].getTime()||s.event(a.select(".brush"))})),(0,c.default)(this,"setShowRuleEditorFlyoutFunction",(e=>{this.setState({showRuleEditorFlyout:e})})),(0,c.default)(this,"unsetShowRuleEditorFlyoutFunction",(()=>{this.setState({showRuleEditorFlyout:()=>{}})})),this.state={popoverData:null,popoverCoords:[0,0],showRuleEditorFlyout:()=>{}},this.mlTimeSeriesExplorer=(0,j.timeSeriesExplorerServiceFactory)(t.services.uiSettings,t.services.mlServices.mlApi,t.services.mlServices.mlResultsService),this.getTimeBuckets=(0,_.E)(t.services.uiSettings).getTimeBuckets}componentWillUnmount(){h().select(this.rootNode).html(""),null!==this.rowMouseenterSubscriber&&this.rowMouseenterSubscriber.unsubscribe(),null!==this.rowMouseleaveSubscriber&&this.rowMouseleaveSubscriber.unsubscribe()}componentDidMount(){const{svgWidth:e,svgHeight:t}=this.props,{focusHeight:a,focusChartHeight:s}=t?$(t):{};this.vizWidth=e-X.left-X.right;const o=this.vizWidth;this.focusXScale=h().time.scale().range([0,o]),this.focusYScale=h().scale.linear().range([null!=a?a:G,W]);const i=this.focusXScale,r=this.focusYScale;this.focusXAxis=h().svg.axis().scale(i).orient("bottom").innerTickSize(-(null!=s?s:Y)).outerTickSize(0).tickPadding(10),this.focusYAxis=h().svg.axis().scale(r).orient("left").innerTickSize(-o).outerTickSize(0).tickPadding(10),this.focusValuesLine=h().svg.line().x((function(e){return i(e.date)})).y((function(e){return r(e.value)})).defined((e=>null!==e.value)),this.focusBoundedArea=h().svg.area().x((function(e){return i(e.date)||1})).y0((function(e){return r(e.upper)})).y1((function(e){return r(e.lower)})).defined((e=>null!==e.lower&&null!==e.upper)),this.contextXScale=h().time.scale().range([0,o]),this.contextYScale=h().scale.linear().range([60,3]),this.fieldFormat=void 0,this.annotateBrush=D.call(this),this.brush=h().svg.brush(),this.mask=void 0;const n=this.highlightFocusChartAnomaly.bind(this),l=O.bind(this),c=this.unhighlightFocusChartAnomaly.bind(this),u=R.bind(this);this.rowMouseenterSubscriber=k.l.rowMouseenter$.subscribe(function({record:e,type:t="anomaly"}){null===this.state.popoverData&&("anomaly"===t?n(e):"annotation"===t&&l(e))}.bind(this)),this.rowMouseleaveSubscriber=k.l.rowMouseleave$.subscribe((function({record:e,type:t="anomaly"}){"anomaly"===t?c():u(e)})),this.renderChart(),this.drawContextChartSelection(),this.renderFocusChart()}componentDidUpdate(e){!1!==this.props.renderFocusChartOnly&&e.svgWidth===this.props.svgWidth&&e.showAnnotations===this.props.showAnnotations&&e.annotationData===this.props.annotationData||(this.renderChart(),this.drawContextChartSelection()),this.renderFocusChart(),null===this.props.annotation&&h().select(this.rootNode).select("g.ml-annotation__brush").call(this.annotateBrush.extent([0,0]))}renderChart(){const{contextChartData:e,contextForecastData:t,detectorIndex:a,modelPlotEnabled:s,selectedJob:o,svgWidth:i,svgHeight:r,showAnnotations:n}=this.props,l=this.createFocusChart.bind(this),c=this.drawContextElements.bind(this),u=this.focusXScale,d=this.focusYAxis,m=this.focusYScale,p=function(e,t){const a=e?U:0,s=t&&t<V?V:t,{focusHeight:o}=t?$(s):{};return(null!=o?o:G)+60+30+a+H+X.top+X.bottom}(n,r),{focusHeight:f}=r?$(r):{},g=h().select(this.rootNode);if(g.selectAll("*").remove(),void 0===o)return;if(this.fieldFormat=this.context.services.mlServices.mlFieldFormatService.getFieldFormat(o.job_id,a),void 0===e)return;const x=this.fieldFormat,v=g.append("svg").attr("width",i).attr("height",p);let b,S;if(!0===s||void 0!==t&&t.length>0){const a=void 0===t?e:e.concat(t);b=h().min(a,(e=>Math.min(e.value,e.lower))),S=h().max(a,(e=>Math.max(e.value,e.upper)))}else b=h().min(e,(e=>e.value)),S=h().max(e,(e=>e.value));const y=S>0?Math.pow(10,Math.ceil(Math.log10(Math.abs(S)))):S,M=b>=0?b:-1*Math.pow(10,Math.ceil(Math.log10(Math.abs(b))));m.domain([M,y]);let F=0;v.append("g").attr("class","temp-axis-label tick").selectAll("text.temp.axis").data(m.ticks()).enter().append("text").text((e=>void 0!==x?x.convert(e,"text"):m.tickFormat()(e))).each((function(){F=Math.max(this.getBBox().width+d.tickPadding(),F)})).remove(),g.select(".temp-axis-label").remove(),X.left=Math.max(F,40),this.vizWidth=Math.max(i-X.left-X.right,0),u.range([0,this.vizWidth]),d.innerTickSize(-this.vizWidth),void 0!==f&&m.range([f,W]);const E=v.append("g").attr("class","focus-chart").attr("transform","translate("+X.left+","+X.top+")"),w=v.append("g").attr("class","context-chart").attr("transform","translate("+X.left+","+((null!=f?f:G)+X.top+H)+")");v.append("defs").append("mask").attr("id",I).append("rect").attr("x",0).attr("y",0).attr("width",this.vizWidth).attr("height",null!=f?f:G).style("fill","white"),l(E,this.vizWidth,null!=f?f:G),c(w,this.vizWidth,60,30,U)}drawContextChartSelection(){const{contextChartData:e,contextForecastData:t,zoomFrom:a,zoomTo:s}=this.props;if(void 0===e)return;let o,i;const r=this.contextXScale.domain()[0].getTime(),n=this.contextXScale.domain()[1].getTime();let l=e;if(void 0!==t&&(l=l.concat(t)),o=a?a.getTime():(0,d.reduce)(l,((e,t)=>Math.min(e,t.date.getTime())),new Date(2099,12,31).getTime()),o=Math.max(o,r),i=s?s.getTime():(0,d.reduce)(l,((e,t)=>Math.max(e,t.date.getTime())),0),i=Math.min(i,n),o!==r||i!==n){this.setContextBrushExtent(new Date(o),new Date(i));const e={min:f()(new Date(o)),max:f()(o)};this.selectedBounds=e}else{const e=this.contextXScale.domain(),t={min:f()(new Date(e[0])),max:f()(e[1])};(0,d.isEqual)(t,this.selectedBounds)||(this.selectedBounds=t,this.setContextBrushExtent(new Date(e[0]),new Date(e[1])))}}createFocusChart(e,t,a){const{contextForecastData:s}=this.props,{focusChartHeight:o}=this.props.svgHeight?$(this.props.svgHeight):{},i=e.append("g").attr("class","focus-zoom");i.append("rect").attr("x",0).attr("y",0).attr("width",t).attr("height",W).attr("class","chart-border"),this.createZoomInfoElements(i,t);const r=this.annotateBrush.bind(this);let n=0,l=0;null!==this.props.annotation&&(n=this.focusXScale(this.props.annotation.timestamp),l=function(e,t){const a=t(e.timestamp)+1,s=void 0!==e.end_timestamp?t(e.end_timestamp)-1:a+8;return Math.max(8,s-a)}(this.props.annotation,this.focusXScale)),e.append("g").attr("class","ml-annotation__brush").call(r).selectAll("rect").attr("x",n).attr("y",W).attr("width",l).attr("height",null!=o?o:Y),e.append("g").classed("ml-annotations",!0),e.append("rect").attr("x",0).attr("y",W).attr("width",t).attr("height",null!=o?o:Y).attr("class","chart-border");const c=e.append("g").attr("class","x-axis-background");c.append("rect").attr("x",0).attr("y",a).attr("width",t).attr("height",H),c.append("line").attr("x1",0).attr("y1",a).attr("x2",0).attr("y2",a+H),c.append("line").attr("x1",t).attr("y1",a).attr("x2",t).attr("y2",a+H),c.append("line").attr("x1",0).attr("y1",a+H).attr("x2",t).attr("y2",a+H);const u=e.append("g");u.append("g").attr("class","x axis").attr("transform","translate(0,"+a+")"),u.append("g").attr("class","y axis"),e.append("path").attr("class","area bounds"),e.append("path").attr("class","values-line"),e.append("g").attr("class","focus-chart-markers"),s&&(e.append("path").attr("class","area forecast").attr("data-test-subj","mlForecastArea"),e.append("path").attr("class","values-line forecast").attr("data-test-subj","mlForecastValuesline"),e.append("g").attr("class","focus-chart-markers forecast").attr("data-test-subj","mlForecastMarkers")),e.append("rect").attr("x",0).attr("y",0).attr("width",t).attr("height",a+24).attr("class","chart-border chart-border-highlight")}renderFocusChart(){const{embeddableMode:e,focusAggregationInterval:t,focusAnnotationData:a,focusChartData:s,focusForecastData:o,modelPlotEnabled:i,selectedJob:n,showAnnotations:l,showForecast:c,showModelBounds:u,zoomFromFocusLoaded:d,zoomToFocusLoaded:m}=this.props,p=Array.isArray(a)?a:[];if(void 0===s)return;const g=s,v=this.contextYScale,b=this.showAnomalyPopover.bind(this),S=this.showFocusChartTooltip.bind(this),y=this.props.tooltipService.hide.bind(this.props.tooltipService),M=h().select(this.rootNode),F=M.select(".focus-chart"),E=t.expression,_=n.analysis_config.bucket_span;if(M.select(".zoom-aggregation-interval").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.zoomAggregationIntervalLabel",{defaultMessage:"(aggregation interval: {focusAggInt}, bucket span: {bucketSpan})",values:{focusAggInt:E,bucketSpan:_}})),void 0===d||void 0===m)return;const k={min:f()(d.getTime()),max:f()(m.getTime())},T=t.asMilliseconds(),j=f()(Math.floor(k.min.valueOf()/T)*T),A=f()(Math.ceil(k.max.valueOf()/T)*T);if(this.focusXScale.domain([j.toDate(),A.toDate()]),s.length>0||void 0!==o&&o.length>0){void 0!==this.fieldFormat?this.focusYAxis.tickFormat((e=>this.fieldFormat.convert(e,"text"))):this.focusYAxis.tickFormat(null);let e=0,t=0,a=g;if(c&&void 0!==o&&o.length>0&&(a=g.concat(o)),e=h().min(a,(e=>{let t=e.value;return null===t&&void 0!==e.anomalyScore&&void 0!==e.actual&&(t=Array.isArray(e.actual)?e.actual[0]:e.actual),void 0!==e.lower?null!=t?Math.min(t,e.lower):e.lower:t||0})),t=h().max(a,(e=>{let t=e.value;return null===t&&void 0!==e.anomalyScore&&void 0!==e.actual&&(t=Array.isArray(e.actual)?e.actual[0]:e.actual),void 0!==e.upper?Math.max(t,e.upper):t||0})),t===e&&(this.contextYScale.domain()[0]!==v.domain()[1]&&e>=v.domain()[0]&&t<=v.domain()[1]?(e=v.domain()[0],t=v.domain()[1]):(e-=.05*e,t+=.05*t)),l&&p&&p.length>0){const a=N(p),s=h().max(Object.keys(a).map((e=>a[e])));t+=Math.abs(t-e)*((s+1)/5)}this.focusYScale.domain([e,t])}else this.focusYScale.domain([0,10]),this.focusYAxis.tickFormat("");const C=this.getTimeBuckets();C.setInterval("auto"),C.setBounds(k);const D=C.getScaledDateFormat();F.select(".x.axis").call(this.focusXAxis.ticks((0,w.Vc)(this.vizWidth),D).tickFormat((e=>f()(e).format(D)))),F.select(".y.axis").call(this.focusYAxis),(0,w.PF)(F.select(".x.axis"),this.vizWidth),!0===i&&F.select(".area.bounds").attr("d",this.focusBoundedArea(g)).classed("hidden",!u);const{focusChartHeight:O,focusHeight:R}=this.props.svgHeight?$(this.props.svgHeight):{};!function(e,t,a,s,o,i,r,n,l){const c={};t.forEach((e=>{if(void 0!==e.key){const t=(e.end_timestamp||0)-e.timestamp;c[e.key]=t}})),t.sort(((e,t)=>void 0===e.key||void 0===t.key?0:c[t.key]-c[e.key]));const u=N(t),d=function(e){r(e,this)},m=e=>{l.setValue(null),l.setValue(e)},h=e.select(".ml-annotations").selectAll("g.ml-annotation").data(t||[],(e=>e._id||""));h.enter().append("g").classed("ml-annotation",!0);const p=h.selectAll(".ml-annotation__rect").data((e=>[e]));p.enter().append("rect").classed("ml-annotation__rect",!0).attr("mask",`url(#${I})`).on("mouseover",d).on("mouseout",n).on("click",m),p.attr("x",(e=>{const t=f()(e.timestamp);return Math.max(o(t),0)})).attr("y",(e=>26+28*(void 0!==e.key?u[e.key]:1))).attr("height",(e=>{const t=void 0!==e.key?u[e.key]:1;return s-2-0-28*t})).attr("width",(e=>{const t=o(f()(e.timestamp))+1,a=void 0!==e.end_timestamp?o(f()(e.end_timestamp))-1:t+8;return Math.max(8,a-t)})),p.exit().remove();const g=h.selectAll(".ml-annotation__text-rect").data((e=>[e])),x=h.selectAll(".ml-annotation__text").data((e=>[e]));function v(e){const t=o.domain()[0],a=o.domain()[1],s=f()(e),i=Math.max(o(t),o(s));return Math.min(o(a)-32,i)}g.enter().append("rect").classed("ml-annotation__text-rect",!0).attr("width",24).attr("height",20).on("mouseover",d).on("mouseout",n).on("click",m),x.enter().append("text").classed("ml-annotation__text",!0).on("mouseover",d).on("mouseout",n).on("click",m),x.attr("x",(e=>v(e.timestamp)+17)).attr("y",(e=>44+28*(void 0!==e.key?u[e.key]:1))).text((e=>e.key)),g.attr("x",(e=>v(e.timestamp)+5)).attr("y",(e=>30+28*(void 0!==e.key?u[e.key]:1))),g.exit().remove(),x.exit().remove(),h.classed("ml-annotation--hidden",!i),h.exit().remove()}(F,p,0,null!=O?O:Y,this.focusXScale,l,S,y,this.props.annotationUpdatesService),F.select(".ml-annotation__brush").style("display",!l||e?"none":null),F.select(".values-line").attr("d",this.focusValuesLine(g)),(0,w.lj)(g,F,this.focusValuesLine);const B=M.select(".focus-chart-markers").selectAll(".metric-value").data(g.filter((e=>(null!==e.value||"number"==typeof e.anomalyScore)&&!(0,w.A4)(e)))),P=this;B.exit().remove(),B.enter().append("circle").attr("r",w.$d).on("click",(function(e){h().event.preventDefault(),void 0!==e.anomalyScore&&b(e,this)})).on("mouseover",(function(e){null===P.state.popoverData&&S(e,this)})).on("mouseout",(()=>this.props.tooltipService.hide())),B.attr("cx",(e=>this.focusXScale(e.date))).attr("cy",(e=>this.focusYScale(e.value))).attr("data-test-subj",(e=>void 0!==e.anomalyScore?"mlAnomalyMarker":void 0)).attr("class",(e=>{let t="metric-value";return void 0!==e.anomalyScore&&(t+=` anomaly-marker ${(0,x.AI)(e.anomalyScore).id}`),t}));const L=M.select(".focus-chart-markers").selectAll(".multi-bucket").data(g.filter((e=>null!==e.anomalyScore&&!0===(0,w.A4)(e))));L.exit().remove(),L.enter().append("path").attr("d",h().svg.symbol().size(w.wK).type("cross")).on("click",(function(e){h().event.preventDefault(),void 0!==e.anomalyScore&&b(e,this)})).on("mouseover",(function(e){S(e,this)})).on("mouseout",(()=>this.props.tooltipService.hide())),L.attr("transform",(e=>`translate(${this.focusXScale(e.date)}, ${this.focusYScale(e.value)})`)).attr("data-test-subj","mlAnomalyMarker").attr("class",(e=>`anomaly-marker multi-bucket ${(0,x.AI)(e.anomalyScore).id}`));const z=M.select(".focus-chart-markers").selectAll(".scheduled-event-marker").data(g.filter((e=>void 0!==e.scheduledEvents)));if(z.exit().remove(),z.enter().append("rect").on("mouseover",(function(e){S(e,this)})).on("mouseout",(()=>y())).attr("width",2*w.$d).attr("height",w.Kv).attr("class","scheduled-event-marker").attr("rx",1).attr("ry",1),z.attr("x",(e=>this.focusXScale(e.date)-w.$d)).attr("y",(e=>{const t=this.focusYScale(e.value);return isNaN(t)?-(null!=R?R:G)-3:t-3})),void 0!==o){F.select(".area.forecast").attr("d",this.focusBoundedArea(o)).classed("hidden",!c),F.select(".values-line.forecast").attr("d",this.focusValuesLine(o)).classed("hidden",!c);const e=M.select(".focus-chart-markers.forecast").selectAll(".metric-value").data(o);e.exit().remove(),e.enter().append("circle").attr("r",w.$d).on("mouseover",(function(e){S(e,this)})).on("mouseout",(()=>this.props.tooltipService.hide())),e.attr("cx",(e=>this.focusXScale(e.date))).attr("cy",(e=>this.focusYScale(e.value))).attr("class","metric-value").classed("hidden",!c)}}createZoomInfoElements(e,t){const{autoZoomDuration:a,bounds:s,modelPlotEnabled:o}=this.props,i=this.setZoomInterval.bind(this),n=s.max.unix()-s.min.unix(),l=10/this.vizWidth*n;let c=10;const u=e.append("text").attr("x",c).attr("y",17).attr("class","zoom-info-text").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.zoomLabel",{defaultMessage:"Zoom:"})),m=[{durationMs:a,label:"auto"}];if((0,d.each)(J,(e=>{e.duration.asSeconds()>l&&e.duration.asSeconds()<n&&m.push({durationMs:e.duration.asMilliseconds(),label:e.label})})),c+=u.node().getBBox().width+4,(0,d.each)(m,(t=>{const a=e.append("a").attr("data-ms",t.durationMs).attr("href","").append("text").attr("x",c).attr("y",17).attr("class","zoom-info-text").text(t.label);c+=a.node().getBBox().width+4})),e.append("text").attr("x",c+6).attr("y",17).attr("class","zoom-info-text zoom-aggregation-interval").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.zoomGroupAggregationIntervalLabel",{defaultMessage:"(aggregation interval: , bucket span: )"})),!1===o){const a=e.append("text").attr("x",300).attr("y",17).attr("class","zoom-info-text").text(r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelBoundsNotAvailableLabel",{defaultMessage:"Model bounds are not available"}));a.attr("x",t-(a.node().getBBox().width+10))}h().select(this.rootNode).selectAll(".focus-zoom a").on("click",(function(){h().event.preventDefault(),i(this.getAttribute("data-ms"))}))}drawContextElements(e,t,a,s){const{bounds:o,contextChartData:i,contextForecastData:r,modelPlotEnabled:n,annotationData:l}=this.props,c=i,u=Array.isArray(l)?[...l].sort(((e,t)=>e.timestamp-t.timestamp)):[];let m=[];if(u.length>0){m=[{start:u[0].timestamp,end:u[0].end_timestamp,annotations:[u[0]]}];let e=u[0].end_timestamp;for(let t=1;t<u.length;t++){if(u[t].timestamp<e){const a=m.pop(),s={...a,end:e,annotations:[...a.annotations,u[t]]};m.push(s)}else m.push({start:u[t].timestamp,end:u[t].end_timestamp,annotations:[u[t]]});e=u[t].end_timestamp}}const p=this.showFocusChartTooltip.bind(this),g=this.props.tooltipService.hide.bind(this.props.tooltipService);this.contextXScale=h().time.scale().range([0,t]).domain(this.calculateContextXAxisDomain());const x=void 0===r?c:c.concat(r),v={min:Number.MAX_VALUE,max:Number.MIN_VALUE};(0,d.each)(x,(e=>{var t,a;const s=null!==(t=e.lower)&&void 0!==t?t:Number.MAX_VALUE,o=null!==(a=e.upper)&&void 0!==a?a:Number.MIN_VALUE;v.min=Math.min(e.value,s,v.min),v.max=Math.max(e.value,o,v.max)}));let b=v.min,S=v.max;const y={min:b,max:S};if(!0===n||void 0!==r&&r.length>0){const e={min:Number.MAX_VALUE,max:Number.MIN_VALUE};(0,d.each)(x,(t=>{e.min=Math.min(t.lower,e.min),e.max=Math.max(t.upper,e.max)})),b=Math.min(b,e.min),S=Math.max(S,e.max),v.max-v.min<.5*(S-b)&&(v.min>b&&(y.min=v.min-.5*(v.max-v.min)),v.max<S&&(y.max=v.max+.5*(v.max-v.min)))}this.contextYScale=h().scale.linear().range([a,3]).domain([y.min,y.max]);const M=e.append("g").attr("class","axis"),F=a+s+U;M.append("line").attr("x1",0).attr("y1",0).attr("x2",0).attr("y2",F),M.append("line").attr("x1",t).attr("y1",0).attr("x2",t).attr("y2",F),M.append("line").attr("x1",0).attr("y1",F).attr("x2",t).attr("y2",F);const E=this.getTimeBuckets();E.setInterval("auto"),E.setBounds(o);const _=E.getScaledDateFormat(),k=h().svg.axis().scale(this.contextXScale).orient("top").innerTickSize(-a).outerTickSize(0).tickPadding(0).ticks((0,w.Vc)(t,_)).tickFormat((e=>f()(e).format(_)));e.datum(c);const j=h().svg.area().x((e=>this.contextXScale(e.date))).y0((e=>this.contextYScale(Math.min(y.max,Math.max(e.lower,y.min))))).y1((e=>this.contextYScale(Math.max(y.min,Math.min(e.upper,y.max))))).defined((e=>null!==e.lower&&null!==e.upper));!0===n&&e.append("path").datum(c).attr("class","area bounds").attr("d",j);const A=h().svg.line().x((e=>this.contextXScale(e.date))).y((e=>this.contextYScale(e.value))).defined((e=>null!==e.value));e.append("path").datum(c).attr("class","values-line").attr("d",A),(0,w.lj)(c,e,A,1),e.append("g").classed("ml-annotation__context",!0);const[C,I]=this.contextXScale.range(),D=e.select(".ml-annotation__context").selectAll("g.ml-annotation__context-item").data(m,(e=>`${e.start}-${e.end}`||""));D.enter().append("g").classed("ml-annotation__context-item",!0);const N=D.selectAll(".ml-annotation__context-rect").data((e=>[e]));N.enter().append("rect").on("mouseover",(function(e){p(1===e.annotations.length?e.annotations[0]:e,this)})).on("mouseout",(()=>g())).classed("ml-annotation__context-rect",!0),N.attr("x",(e=>{const t=f()(e.start);let a=this.contextXScale(t);return a-w.nD<=C&&(a=0),a+w.nD>=I&&(a=I-w.nD),a})).attr("y",a+s+2).attr("height",w.nD).attr("width",(e=>{const t=Math.max(this.contextXScale(f()(e.start))+1,C),a=Math.min(I,void 0!==e.end?this.contextXScale(f()(e.end))-1:t+8);return Math.max(8,a-t)})),N.exit().remove(),void 0!==r&&(e.append("path").datum(r).attr("class","area forecast").attr("d",j),e.append("path").datum(r).attr("class","values-line forecast").attr("d",A));const O=e.append("g").attr("class","swimlane").attr("transform","translate(0,"+a+")");this.drawSwimlane(O,t,s),this.mask=new T(e,i,n,s).x(this.contextXScale).y(this.contextYScale),e.append("g").attr("class","x axis context-chart-axis").call(k),e.selectAll(".x.context-chart-axis text").attr("dy",a-5),(0,w.PF)(e.selectAll(".x.context-chart-axis"),t),this.drawContextBrush(e)}setZoomInterval(e){const{bounds:t,zoomTo:a}=this.props,s=t.min.valueOf(),o=t.max.valueOf(),i=+e;let r=a.getTime(),n=r-i;n<s&&(n=s,r=Math.min(s+i,o)),this.setContextBrushExtent(new Date(n),new Date(r))}showAnomalyPopover(e,t){const a=e.date.getTime(),s=(0,F.O)(this.props.tableData.anomalies,a);if(s){s.source.timestamp=a;const e=t.getBoundingClientRect(),o=this.rootNode.getBoundingClientRect(),i=Math.round(e.x+e.width/2-o.x),r=Math.round(e.y+e.height/2-o.y)-28;this.props.tooltipService.hide(),this.setState({popoverData:s,popoverCoords:[i,r]})}}showFocusChartTooltip(e,t){var a;const{modelPlotEnabled:s}=this.props,o=this.fieldFormat,i="single_metric_viewer",n=[{label:(0,y.v_)(e.date)}];if(void 0!==e.anomalyScore){const t=parseInt(e.anomalyScore);if(n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.anomalyScoreLabel",{defaultMessage:"anomaly score"}),value:(0,v.m)(t),color:this.props.anomalyColorScale(t),seriesIdentifier:{key:i},valueAccessor:"anomaly_score"}),!0===(0,w.pn)(e)&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.multiBucketAnomalyLabel",{defaultMessage:"multi-bucket impact"}),value:(0,w.gX)(e),seriesIdentifier:{key:i},valueAccessor:"multi_bucket_impact"}),e.metricFunction&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.metricActualPlotFunctionLabel",{defaultMessage:"function"}),value:e.metricFunction,seriesIdentifier:{key:i},valueAccessor:"metric_function"}),!1===s){if(void 0!==e.actual&&"rare"!==e.function)n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.actualLabel",{defaultMessage:"actual"}),value:(0,E.Fl)(e.actual,e.function,o),seriesIdentifier:{key:i},valueAccessor:"actual"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.typicalLabel",{defaultMessage:"typical"}),value:(0,E.Fl)(e.typical,e.function,o),seriesIdentifier:{key:i},valueAccessor:"typical"});else if(void 0!==e.value&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.valueLabel",{defaultMessage:"value"}),value:(0,E.Fl)(e.value,e.function,o),seriesIdentifier:{key:i},valueAccessor:"value"}),void 0!==e.byFieldName&&void 0!==e.numberOfCauses){const t=e.numberOfCauses,a=(0,A.lt)(e.byFieldName);n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.moreThanOneUnusualByFieldValuesLabel",{defaultMessage:"{numberOfCauses}{plusSign} unusual {byFieldName} values",values:{numberOfCauses:t,byFieldName:a,plusSign:t<10?"":"+"}}),seriesIdentifier:{key:i},valueAccessor:"numberOfCauses"})}}else e.annotations||(n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelPlotEnabled.actualLabel",{defaultMessage:"actual"}),value:(0,E.Fl)(e.actual,e.function,o),seriesIdentifier:{key:i},valueAccessor:"actual"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelPlotEnabled.upperBoundsLabel",{defaultMessage:"upper bounds"}),value:(0,E.Fl)(e.upper,e.function,o),seriesIdentifier:{key:i},valueAccessor:"upper_bounds"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.modelPlotEnabled.lowerBoundsLabel",{defaultMessage:"lower bounds"}),value:(0,E.Fl)(e.lower,e.function,o),seriesIdentifier:{key:i},valueAccessor:"lower_bounds"}))}else!0===(0,d.get)(e,"isForecast",!1)?n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScore.predictionLabel",{defaultMessage:"prediction"}),value:(0,E.Fl)(e.value,e.function,o),seriesIdentifier:{key:i},valueAccessor:"prediction"}):void 0!==e.value&&null!==e.value&&n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScore.valueLabel",{defaultMessage:"value"}),value:(0,E.Fl)(e.value,e.function,o),seriesIdentifier:{key:i},valueAccessor:"value"}),e.annotations||!0!==s||(n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScoreAndModelPlotEnabled.upperBoundsLabel",{defaultMessage:"upper bounds"}),value:(0,E.Fl)(e.upper,e.function,o),seriesIdentifier:{key:i},valueAccessor:"upper_bounds"}),n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.withoutAnomalyScoreAndModelPlotEnabled.lowerBoundsLabel",{defaultMessage:"lower bounds"}),value:(0,E.Fl)(e.lower,e.function,o),seriesIdentifier:{key:i},valueAccessor:"lower_bounds"}));if(void 0!==e.scheduledEvents&&e.scheduledEvents.forEach(((t,a)=>{n.push({label:r.i18n.translate("xpack.ml.timeSeriesExplorer.timeSeriesChart.scheduledEventsLabel",{defaultMessage:"scheduled event{counter}",values:{counter:e.scheduledEvents.length>1?` #${a+1}`:""}}),value:t,seriesIdentifier:{key:i},valueAccessor:`scheduled_events_${a+1}`})})),void 0!==e.annotation){n.length=0,n.push({label:e.annotation});let t=f()(e.timestamp).format("MMMM Do YYYY, HH:mm");void 0!==e.end_timestamp&&(t+=` - ${f()(e.end_timestamp).format("MMMM Do YYYY, HH:mm")}`),n.push({label:t,seriesIdentifier:{key:i},valueAccessor:"timespan"})}(null===(a=e.annotations)||void 0===a?void 0:a.length)>1&&e.annotations.forEach((e=>{var t;let a=f()(e.timestamp).format("MMMM Do YYYY, HH:mm");void 0!==e.end_timestamp&&(a+=` - ${f()(e.end_timestamp).format("HH:mm")}`),n.push({label:a,value:`${e.annotation}`,seriesIdentifier:{key:"anomaly_timeline",specId:null!==(t=e._id)&&void 0!==t?t:`${e.annotation}-${e.timestamp}-label`},valueAccessor:"annotation"})}));let l=2*w.$d;if("rect"===t.tagName.toLowerCase()){const e=Number(t.getAttribute("x"));e<0&&(l=Math.abs(e))}this.props.tooltipService.show(n,t,{x:l,y:0})}highlightFocusChartAnomaly(e){const{focusChartData:t,focusAggregationInterval:a}=this.props,s=this.focusXScale,o=this.focusYScale,i=this.showFocusChartTooltip.bind(this),r=e.source.timestamp,n=this.mlTimeSeriesExplorer.findChartPointForAnomalyTime(t,r,a),l=h().select(this.rootNode);if(void 0!==n){const e=l.select(".focus-chart-markers").selectAll(".focus-chart-highlighted-marker").data([n]);!0===(0,w.A4)(n)?e.enter().append("path").attr("d",h().svg.symbol().size(w.wK).type("cross")).attr("transform",(e=>`translate(${s(e.date)}, ${o(e.value)})`)).attr("data-test-subj","mlAnomalyMarker").attr("class",(e=>`anomaly-marker multi-bucket ${(0,x.AI)(e.anomalyScore).id} highlighted`)):e.enter().append("circle").attr("r",w.$d).attr("cx",(e=>s(e.date))).attr("cy",(e=>o(e.value))).attr("data-test-subj","mlAnomalyMarker").attr("class",(e=>`anomaly-marker metric-value ${(0,x.AI)(e.anomalyScore).id} highlighted`));const t=l.selectAll(".focus-chart-markers .anomaly-marker.highlighted");t.length&&i(n,t[0][0])}}unhighlightFocusChartAnomaly(){h().select(this.rootNode).select(".focus-chart-markers").selectAll(".anomaly-marker.highlighted").remove(),this.props.tooltipService.hide()}shouldComponentUpdate(){return!0}setRef(e){this.rootNode=e}closePopover(){this.setState({popoverData:null,popoverCoords:[0,0]})}render(){return(0,z.jsx)(i().Fragment,null,(0,z.jsx)(L.z,{selectedJob:this.props.selectedJob,setShowFunction:this.setShowRuleEditorFlyoutFunction,unsetShowFunction:this.unsetShowRuleEditorFlyoutFunction}),null!==this.state.popoverData&&(0,z.jsx)("div",{style:{position:"absolute",marginLeft:this.state.popoverCoords[0],marginTop:this.state.popoverCoords[1]}},(0,z.jsx)(g.EuiPopover,{isOpen:!0,closePopover:()=>this.closePopover(),panelPaddingSize:"none",anchorPosition:"upLeft"},(0,z.jsx)(P.F,{anomaly:this.state.popoverData,selectedJob:this.props.selectedJob,bounds:this.props.bounds,showMapsLink:!1,showViewSeriesLink:!1,isAggregatedData:"second"!==this.props.tableData.interval,interval:this.props.tableData.interval,showRuleEditorFlyout:this.state.showRuleEditorFlyout,onItemClick:()=>this.closePopover(),sourceIndicesWithGeoFields:this.props.sourceIndicesWithGeoFields}))),(0,z.jsx)("div",{className:"ml-timeseries-chart-react",ref:this.setRef.bind(this)}))}}(0,c.default)(TimeseriesChartIntl,"contextType",M.context);const q=e=>{const t=(0,o.useContext)(B.m),a=(0,u.A)(t.isAnnotationInitialized$()),{euiTheme:i}=(0,g.useEuiTheme)(),r=(0,o.useMemo)((()=>h().scale.threshold().domain([b.I.WARNING,b.I.MINOR,b.I.MAJOR,b.I.CRITICAL]).range([(0,S.CP)(b.I.LOW,i),(0,S.CP)(b.I.WARNING,i),(0,S.CP)(b.I.MINOR,i),(0,S.CP)(b.I.MAJOR,i),(0,S.CP)(b.I.CRITICAL,i)])),[i]);return void 0===a?null:(0,z.jsx)(TimeseriesChartIntl,(0,s.default)({annotation:a,anomalyColorScale:r},e,{annotationUpdatesService:t}))};var Z=a(42678),K=a(67140),Q=a(56509);const ee=({bounds:e,detectorIndex:t,embeddableMode:a,renderFocusChartOnly:i,selectedJob:c,selectedEntities:u,showAnnotations:d,showForecast:m,showModelBounds:h,chartProps:p,lastRefresh:f,contextAggregationInterval:g,tableData:x={anomalies:[],interval:"second"},sourceIndicesWithGeoFields:v})=>{const{toasts:b}=(0,K.E$)(),{services:{mlServices:{mlApi:S}}}=(0,K.hk)(),y=(0,o.useContext)(B.m),[M,F]=(0,o.useState)([]),E=(0,o.useCallback)((e=>{b.addDanger({title:r.i18n.translate("xpack.ml.timeSeriesExplorer.mlSingleMetricViewerChart.annotationsErrorTitle",{defaultMessage:"An error occurred fetching annotations"}),...e?{text:(0,n.P)(e)}:{}})}),[]),w=(0,_.t)();return(0,o.useEffect)((()=>{let a=!1;const s=(0,Q.s)(t,u,c),o=Array.isArray(s)?s.filter((e=>null!==e.fieldValue)):void 0,i=w.getBoundsRoundedToInterval(e,g,!1);return(async e=>{try{const s=await S.annotations.getAnnotations({jobIds:[e],earliestMs:i.min.valueOf(),latestMs:i.max.valueOf(),maxAnnotations:Z.b,detectorIndex:t,entities:o});a||Array.isArray(s.annotations[e])&&F(s.annotations[e])}catch(e){E(e)}})(c.job_id),()=>{a=!0}}),[c.job_id,t,f,u,e,g]),p.svgHeight&&(p.svgHeight-=32),(0,z.jsx)("div",{className:"ml-timeseries-chart","data-test-subj":"mlSingleMetricViewerChart"},(0,z.jsx)(l.Y,null,(o=>(0,z.jsx)(q,(0,s.default)({},p,{annotationUpdatesService:y,annotationData:M,bounds:e,detectorIndex:t,embeddableMode:a,renderFocusChartOnly:i,selectedJob:c,showAnnotations:d,showForecast:m,showModelBounds:h,tooltipService:o,tableData:x,sourceIndicesWithGeoFields:v})))))}},23289:(e,t,a)=>{a.d(t,{i:()=>i});var s=a(81319),o=(a(84286),a(96791));const i=({errorMsg:e})=>(0,o.jsx)(s.EuiEmptyPrompt,{iconType:"warning",title:(0,o.jsx)("h2",null,e)})},49183:(e,t,a)=>{a.d(t,{H:()=>r}),a(84286);var s=a(81319),o=a(75008),i=a(96791);const r=({dataNotChartable:e,entities:t})=>(0,i.jsx)(s.EuiEmptyPrompt,{iconType:"info",title:(0,i.jsx)("h2",null,o.i18n.translate("xpack.ml.timeSeriesExplorer.noResultsFoundLabel",{defaultMessage:"No results found"})),body:e?(0,i.jsx)("p",null,o.i18n.translate("xpack.ml.timeSeriesExplorer.dataNotChartableDescription",{defaultMessage:"Model plot is not collected for the selected {entityCount, plural, one {entity} other {entities}}\nand the source data cannot be plotted for this detector.",values:{entityCount:t.length}})):(0,i.jsx)("p",null,o.i18n.translate("xpack.ml.timeSeriesExplorer.tryWideningTheTimeSelectionDescription",{defaultMessage:"Try widening the time selection or moving further back in time."}))})},82690:(e,t,a)=>{a.d(t,{U:()=>n}),a(84286);var s=a(75008),o=a(75879),i=a(23835),r=a(96791);const n=({embeddableMode:e})=>(0,r.jsx)(i.U,{anchorPosition:"upCenter",title:s.i18n.translate("xpack.ml.timeSeriesExplorer.popoverTitle",{defaultMessage:"Single time series analysis"})},(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverBasicExplanation",defaultMessage:"This chart illustrates the actual data values over time for a specific detector. You can examine an event by sliding the time selector and changing its length. For the most accurate view, set the zoom size to auto."})),(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverAnomalyExplanation",defaultMessage:"An anomaly score is calculated for each bucket time interval, with a value from 0 to 100. Anomalous events are highlighted in colors that indicate their severity. If an anomaly is depicted with a cross symbol instead of a dot, it has a moderate, significant, or high multi-bucket impact. This extra analysis can catch anomalies even when they fall within the bounds of expected behavior."})),(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverForecastExplanation",defaultMessage:"If you create a forecast, predicted data values are added to the chart. A shaded area around these values represents the confidence level; as you forecast further into the future, the confidence level generally decreases."})),!e&&(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverAnnotationsExplanation",defaultMessage:"You can also optionally annotate your job results by drag-selecting a period of time in the chart and adding a description. Some annotations are generated automatically to indicate noteworthy occurrences."})),(0,r.jsx)("p",null,(0,r.jsx)(o.FormattedMessage,{id:"xpack.ml.timeSeriesExplorer.popoverModelPlotExplanation",defaultMessage:"If model plot is enabled, you can optionally show model bounds, which are represented by a shaded area in the chart. As the job analyzes more data, it learns to more closely predict the expected patterns of behavior."})))},52535:(e,t,a)=>{a.d(t,{e:()=>n,I:()=>r});var s=a(30770),o=a(75008),i=a(62106);function r(e,t,a,r,n,l){const c=r.jobs.filter(i.nO),u=c.map((e=>e.job_id)),d=(0,s.difference)(t,u),m=(0,s.without)(t,...d);if(1===d.length){const t=d[0],a=e.find((e=>e.id===t));if(void 0!==a&&void 0!==a.isNotSingleMetricViewerJobMessage){const e=o.i18n.translate("xpack.ml.timeSeriesExplorer.canNotViewRequestedJobsWarningWithReasonMessage",{defaultMessage:"You can't view {selectedJobId} in this dashboard because {reason}.",values:{selectedJobId:t,reason:a.isNotSingleMetricViewerJobMessage}});n.addWarning({title:e,"data-test-subj":"mlTimeSeriesExplorerDisabledJobReasonWarningToast"})}}if(d.length>1){let e=o.i18n.translate("xpack.ml.timeSeriesExplorer.canNotViewRequestedJobsWarningMessage",{defaultMessage:"You can't view requested {invalidIdsCount, plural, one {job} other {jobs}} {invalidIds} in this dashboard",values:{invalidIdsCount:d.length,invalidIds:d.join(", ")}});0===m.length&&u.length>0&&(e+=o.i18n.translate("xpack.ml.timeSeriesExplorer.autoSelectingFirstJobText",{defaultMessage:", auto selecting first job"})),n.addWarning(e)}return m.length>1?(n.addWarning(o.i18n.translate("xpack.ml.timeSeriesExplorer.youCanViewOneJobAtTimeWarningMessage",{defaultMessage:"You can only view one job at a time in this dashboard"})),a("ml",{jobIds:[m[0]]}),!0):d.length>0&&m.length>0?(a("ml",{jobIds:[m[0]]}),!0):1===m.length?m[0]:0===m.length&&c.length>0&&(l({singleSelection:!0,timeseriesOnly:!0}).then((({jobIds:e,time:t})=>{a({ml:{jobIds:e},...void 0!==t?{time:t}:{}})})).catch((e=>{})),!0)}function n(){return{chartDetails:void 0,contextAggregationInterval:void 0,contextChartData:void 0,contextForecastData:void 0,dataNotChartable:!1,entitiesLoading:!1,entityValues:{},focusAnnotationData:[],focusAggregationInterval:{},focusChartData:void 0,focusForecastData:void 0,fullRefresh:!0,hasResults:!1,loadCounter:0,loading:!1,modelPlotEnabled:!1,showAnnotations:!0,showAnnotationsCheckbox:!0,showForecast:!0,showForecastCheckbox:!1,showModelBounds:!0,showModelBoundsCheckbox:!1,svgWidth:0,tableData:void 0,zoomFrom:void 0,zoomTo:void 0,zoomFromFocusLoaded:void 0,zoomToFocusLoaded:void 0,chartDataError:void 0,sourceIndicesWithGeoFields:{}}}},72432:(e,t,a)=>{a.r(t),a.d(t,{timeSeriesSearchServiceFactory:()=>m,useTimeSeriesSearchService:()=>h});var s=a(84286),o=a(30770),i=a(80190),r=a(59711),n=a(98174),l=a(84640),c=a(62106);function u(e,t,a){const s=e.analysis_config,i=s.detectors[t],r={jobId:e.job_id,detectorIndex:t,metricFunction:i.function===n.fB.LAT_LONG?n.fB.LAT_LONG:(0,c.Nc)(i.function),timeField:e.data_description.time_field,interval:e.analysis_config.bucket_span,datafeedConfig:e.datafeed_config,summaryCountFieldName:e.analysis_config.summary_count_field_name};i.function===n.fB.METRIC&&void 0!==a&&(r.metricFunction=a),void 0!==i.field_name&&(r.metricFieldName=i.field_name);const u=s.summary_count_field_name;if(r.metricFunction===n.Az.COUNT&&void 0!==u&&u!==l.Dh&&u!==l.Il){let t;const a=(0,o.get)(e.datafeed_config,"aggregations")||(0,o.get)(e.datafeed_config,"aggs");void 0!==a&&Object.values(a).length>0&&(t=(0,o.get)(Object.values(a)[0],["aggregations",u,n.Az.CARDINALITY,"field"])||(0,o.get)(Object.values(a)[0],["aggs",u,n.Az.CARDINALITY,"field"])),i.function!==n.fB.NON_ZERO_COUNT&&i.function!==n.fB.LOW_NON_ZERO_COUNT&&i.function!==n.fB.HIGH_NON_ZERO_COUNT&&i.function!==n.fB.COUNT&&i.function!==n.fB.HIGH_COUNT&&i.function!==n.fB.LOW_COUNT||void 0===t?(r.metricFunction=n.Az.SUM,r.metricFieldName=u):(r.metricFunction=n.Az.CARDINALITY,r.metricFieldName=void 0)}return r}var d=a(67140);function m(e,t){return{getMetricData:function(t,a,s,r,n,l,d){if((0,c.Uz)(t,a)&&(0,c.s)(t,a,s)){const i=[],c=t.analysis_config.detectors[a];if(void 0!==c.partition_field_name){const e=(0,o.find)(s,{fieldName:c.partition_field_name});void 0!==e&&i.push({fieldName:"partition_field_name",fieldValue:e.fieldName},{fieldName:"partition_field_value",fieldValue:e.fieldValue})}if(void 0!==c.over_field_name){const e=(0,o.find)(s,{fieldName:c.over_field_name});void 0!==e&&i.push({fieldName:"over_field_name",fieldValue:e.fieldName},{fieldName:"over_field_value",fieldValue:e.fieldValue})}if(void 0!==c.by_field_name){const e=(0,o.find)(s,{fieldName:c.by_field_name});void 0!==e&&i.push({fieldName:"by_field_name",fieldValue:e.fieldName},{fieldName:"by_field_value",fieldValue:e.fieldValue})}return e.getModelPlotOutput(t.job_id,a,i,r,n,l)}{const c={success:!0,results:{}},m=u(t,a);return e.getMetricData(m.datafeedConfig.indices.join(","),s,m.datafeedConfig.query,null!=d?d:m.metricFunction,m.metricFieldName,m.summaryCountFieldName,m.timeField,r,n,l,null==m?void 0:m.datafeedConfig).pipe((0,i.map)((e=>((0,o.each)(e.results,((e,t)=>{c.results[t]={actual:e}})),c))))}},getChartDetails:function(e,a,s,i,r,n){return new Promise(((l,c)=>{const d={success:!0,results:{functionLabel:"",entityData:{entities:[]}}},m=u(e,a,n);let h=m.metricFunction;void 0!==m.metricFieldName&&(h+=` ${m.metricFieldName}`),d.results.functionLabel=h;const p=(0,o.filter)(s,(e=>null===e.fieldValue));if(0===p.length)d.results.entityData.count=1,d.results.entityData.entities=s,l(d);else{const e=p.map((e=>e.fieldName));t.getCardinalityOfFields({index:m.datafeedConfig.indices.join(","),fieldNames:e,query:m.datafeedConfig.query,timeFieldName:m.timeField,earliestMs:i,latestMs:r}).then((e=>{(0,o.each)(p,(t=>{d.results.entityData.entities.push({fieldName:t.fieldName,cardinality:(0,o.get)(e,t.fieldName,0)})})),l(d)})).catch((e=>{c(e)}))}}))}}}function h(){const{services:{mlServices:{mlApi:e}}}=(0,d.hk)(),t=(0,r.mlResultsServiceProvider)(e);return(0,s.useMemo)((()=>m(t,e)),[e,t])}},17404:(e,t,a)=>{a.d(t,{$d:()=>d,A4:()=>M,Kv:()=>m,O6:()=>k,OF:()=>f,PF:()=>x,Vc:()=>w,gX:()=>E,k9:()=>A,lj:()=>g,nD:()=>h,pI:()=>S,pn:()=>F,rg:()=>y,wK:()=>p,z9:()=>j});var s=a(47935),o=a.n(s),i=a(73601),r=a(21069),n=a(51783),l=a.n(n),c=a(9506),u=a(48290);const d=7,m=5,h=10,p=100;function f(e=[],t){let a=1/0,s=-1/0;e.forEach((e=>{let t=e.value;const o=Array.isArray(e.actual)?e.actual[0]:e.actual,i=Array.isArray(e.typical)?e.typical[0]:e.typical;null===t&&void 0!==e.anomalyScore&&void 0!==e.actual&&(t=o),void 0!==e.anomalyScore&&void 0!==o?(a=Math.min(a,t,o,i),s=Math.max(s,t,o,i)):(a=Math.min(a,t),s=Math.max(s,t))}));const o={max:s,min:a};if(o.max===o.min){const e=.05*o.max;o.max+=e,o.min-=e}return"count"===t&&o.min<0&&(o.min=0),o}function g(e,t,a,s=1.5){const o=e.reduce(((t,a,s)=>{const o=e[s-1],i=e[s+1];return(void 0===o||o&&null===o.value)&&null!==a.value&&(void 0===i||i&&null===i.value)&&t.push(a),t}),[]),i=(t.select(".values-dots").empty()?t.append("g").classed("values-dots",!0):t.select(".values-dots")).selectAll("circle").data(o);i.enter().append("circle").attr("r",s),i.attr("cx",a.x()).attr("cy",a.y()),i.exit().remove()}function x(e,t){if(void 0===e||void 0===e.selectAll)throw new Error("Missing selection parameter");e.selectAll(".tick text").text((function(){const e=o().select(this.parentNode),a=e.node().getBBox().width,s=o().transform(e.attr("transform")).translate[0];if(s-a/2>=0&&s+a/2<=t)return this.textContent;e.remove()}))}const v=!0,b=!0;function S(e){let t=c.oT.SINGLE_METRIC;if("lat_long"===e.functionDescription||void 0!==e.mapData)return c.oT.GEO_MAP;if(v&&"rare"===e.functionDescription&&!1===e.entityFields.some((e=>"over"===e.fieldType))?t=c.oT.EVENT_DISTRIBUTION:b&&"rare"!==e.functionDescription&&e.entityFields.some((e=>"over"===e.fieldType))&&null!==e.metricFunction&&(t=c.oT.POPULATION_DISTRIBUTION),(t===c.oT.EVENT_DISTRIBUTION||t===c.oT.POPULATION_DISTRIBUTION)&&void 0!==e.datafeedConfig&&void 0!==e.datafeedConfig.script_fields){const a=Object.keys(e.datafeedConfig.script_fields),s=e.entityFields.map((e=>e.fieldName));e.metricFieldName&&s.push(e.metricFieldName),!0==(void 0!==s.find((e=>a.includes(e))))&&(t=c.oT.SINGLE_METRIC)}return t}async function y(e,t,a){const s=l()(t.plotEarliest).toISOString(),o=l()(t.plotLatest).toISOString();let i;return t.entityFields.length>0&&(i={},t.entityFields.forEach((e=>{i[e.fieldName]=e.fieldValue}))),await e.getUrl({page:u.Nh.SINGLE_METRIC_VIEWER,pageState:{jobIds:[t.jobId],refreshInterval:{display:"Off",pause:!0,value:0},timeRange:a,zoom:{from:s,to:o},detectorIndex:t.detectorIndex,entities:i,query:{query_string:{analyze_wildcard:!0,query:"*"}}}},{absolute:!0})}function M(e){return!0===e.isMultiBucketAnomaly}function F(e){return!0===e.isMultiBucketAnomaly}function E(e){const t=void 0!==e.multiBucketImpact?(0,i.qc)(e.multiBucketImpact):0;return new Array(5).fill("■ ",0,t).fill("□ ",t).join("")}function w(e,t){return e/(1.75*(0,r.Un)(l()().format(t),!1))}const _={NEXT:"next",PREVIOUS:"previous"};function k(e,t,a,s){if(t<=0)throw Error("tickInterval must be larger than 0.");const o=[e];function i(e,r){let n,l;switch(r){case _.PREVIOUS:n=e-t,l=n>=a;break;case _.NEXT:n=e+t,l=n<=s}l&&(o.push(n),i(n,r))}return i(e,_.PREVIOUS),i(e,_.NEXT),o.sort(),o}const T=60;function j({detectorLabel:e,entityFields:t}){return e.length+t.map((e=>`${e.fieldName} ${e.fieldValue}`)).join(" ").length>T}function A(e,t,a,s){function i(e){return function(t){switch(e){case _.PREVIOUS:return t-a;case _.NEXT:return t+a}}}function r(t,a){const n=function(t){const a=i(t),s=function(t){const i=e.selectAll(".tick").filter((e=>e===t));if(0===i.length||0===i[0].length)return!1;const r=o().selectAll(i[0]),n=r.select("text").node();if(null===n)return s(a(t));const l=n.getBBox().width,c=function(e){const t=/translate\(\s*([^\s,)]+)([ ,]([^\s,)]+))?\)/.exec(e);return Array.isArray(t)&&t.length>=2?Number(t[1]):NaN}(r.attr("transform"));return{tick:r,ts:t,xMinOffset:c-(l/2+15),xMaxOffset:c+(l/2+15)}};return s}(a),l=n(t);if(!1===l)return;const c=n(i(a)(t));!1!==c&&(c.xMinOffset<0||c.xMaxOffset>s||c.xMaxOffset>l.xMinOffset&&a===_.PREVIOUS||c.xMinOffset<l.xMaxOffset&&a===_.NEXT?(c.tick.select("text").remove(),c.tick.select("line").classed("ml-tick-emphasis",!1),r(l.ts,a)):r(c.ts,a))}e.selectAll("g.tick").select("line").classed("ml-tick-emphasis",!0),r(t,_.PREVIOUS),r(t,_.NEXT)}},28419:(e,t,a)=>{a.d(t,{E:()=>c,t:()=>u});var s=a(84286),o=a(14627),i=a(51783),r=a.n(i),n=a(94925),l=a(67140);function c(e){return{getTimeBuckets:function(){return new n.tT({[o.UI_SETTINGS.HISTOGRAM_MAX_BARS]:e.get(o.UI_SETTINGS.HISTOGRAM_MAX_BARS),[o.UI_SETTINGS.HISTOGRAM_BAR_TARGET]:e.get(o.UI_SETTINGS.HISTOGRAM_BAR_TARGET),dateFormat:e.get("dateFormat"),"dateFormat:scaled":e.get("dateFormat:scaled")})},getBoundsRoundedToInterval:function(e,t,a=!1){const s=t.asMilliseconds(),o=Math.floor(e.min.valueOf()/s)*s;let i=Math.ceil(e.max.valueOf()/s)*s;return!1===a&&(i-=1),{min:r()(o),max:r()(i)}}}}function u(){const{services:{uiSettings:e}}=(0,l.hk)();return(0,s.useMemo)((()=>c(e)),[e])}},90081:(e,t,a)=>{a.r(t),a.d(t,{timeSeriesExplorerServiceFactory:()=>S,useTimeSeriesExplorerService:()=>y});var s=a(84286),o=a(51783),i=a.n(o),r=a(80190),n=a(30770),l=a(73601),c=a(98174),u=a(43627),d=a(64189),m=a(62106),h=a(42678),p=a(72810),f=a(28419),g=a(59711),x=a(84315),v=a(72432),b=a(67140);function S(e,t,a){const s=(0,f.E)(e),o=(0,x.P)(t),g=(0,v.timeSeriesSearchServiceFactory)(a,t);function b(e,t){const a=[];return!0===t?(0,n.each)(e,((e,t)=>{a.push({date:new Date(+t),lower:e.modelLower,value:e.actual,upper:e.modelUpper})})):(0,n.each)(e,((e,t)=>{a.push({date:new Date(+t),value:e.actual})})),a}function S(e){const t=[];return(0,n.each)(e,((e,a)=>{t.push({date:new Date(+a),isForecast:!0,lower:e.forecastLower,value:e.prediction,upper:e.forecastUpper})})),t}function y(e,t,a){let s;if(void 0===e)return s;for(let a=0;a<e.length;a++)if(e[a].date.getTime()===t){s=e[a];break}if(void 0===s){let o;const i=a.asMilliseconds();for(let a=0;a<e.length;a++)if(t-e[a].date.getTime()<i){o=e[a];break}s=o}return s}function M(e,t,a,s,o){const i=[],r=a.asMilliseconds();let u;return void 0!==e&&e.length>0&&(u=e[e.length-1].date.getTime()),t.forEach((t=>{const s=t[p.xL];if(void 0===y(e,s,a)){const e=Math.floor(s/r)*r;-1===i.indexOf(e)&&e!==u&&i.push(e)}})),i.sort(((e,t)=>e-t)),i.forEach((t=>{const a={date:new Date(t),value:null};!0===s&&(a.upper=null,a.lower=null),e.push(a)})),t.forEach((t=>{const s=t[p.xL];if(t.function===c.fB.METRIC&&t.function_description!==o)return;const i=y(e,s,a);if(void 0!==i){const e=t.record_score,a=i.anomalyScore;if(void 0===a||a<e){if(i.anomalyScore=e,i.function=t.function,void 0!==t.actual)null!==i.value&&t.function!==c.fB.METRIC||(i.value=Array.isArray(t.actual)?t.actual[0]:t.actual),i.actual=t.actual,i.typical=t.typical;else{const e=(0,n.get)(t,"causes",[]);if(e.length>0&&(i.byFieldName=t.by_field_name,i.numberOfCauses=e.length,1===e.length)){const e=t.causes[0];i.actual=e.actual,i.typical=e.typical,null===i.value&&(i.value=e.actual)}}void 0!==t.anomaly_score_explanation&&void 0!==t.anomaly_score_explanation.multi_bucket_impact&&(i.multiBucketImpact=t.anomaly_score_explanation.multi_bucket_impact),i.isMultiBucketAnomaly=(0,l.NW)(t)}}})),e}function F(e,t){let a;if(void 0===e)return a;for(let s=0;s<e.length;s++)if(e[s].date.getTime()===t){a=e[s];break}return a}function E(e,t,a){if(void 0!==t){const s=[],o=a.asMilliseconds();let i;void 0!==e&&e.length>0&&(i=e[e.length-1].date.getTime());let r=!1;(0,n.each)(t,((t,a)=>{const n=F(e,+a);if(void 0!==n)n.scheduledEvents=t;else{const n=Math.floor(a/o)*o;if(-1===s.indexOf(n)&&n!==i){const a={date:new Date(n),value:null,scheduledEvents:t};e.push(a),r=!0}}})),r&&e.sort(((e,t)=>e.date.getTime()-t.date.getTime()))}return e}return{getAutoZoomDuration:function(e){let t;if(e){const a=(0,d.P)(e).asSeconds();t=1e3*a*(p.rW-1);const o=Math.floor(1.1*p.rW),r=s.getTimeBuckets();r.setInterval("auto"),r.setBarTarget(Math.floor(p.rW)),r.setMaxBars(o);const n=(new Date).getTime(),l=i()(n),c=i()(n-t);r.setBounds({min:c,max:l});const u=r.getIntervalToNearestMultiple(a).asSeconds();u!==a&&(t*=a/u)}return t},calculateAggregationInterval:function(e,t,a){const o=void 0!==t?t:100,i=Math.floor(1.1*o),r=s.getTimeBuckets();let n;if(r.setInterval("auto"),r.setBounds(e),r.setBarTarget(Math.floor(o)),r.setMaxBars(i),a.analysis_config.bucket_span){const e=(0,d.P)(a.analysis_config.bucket_span).asSeconds();n=r.getIntervalToNearestMultiple(e),n.asSeconds()<e&&(r.setInterval(e+"s"),n=r.getInterval())}return n},calculateInitialFocusRange:function(e,t,a){if(void 0!==e){const o=i()(e.from,"YYYY-MM-DDTHH:mm:ss.SSSZ",!0),r=i()(e.to,"YYYY-MM-DDTHH:mm:ss.SSSZ",!0),n=s.getBoundsRoundedToInterval(a,t,!0),l=n.min,c=n.max;if(o.isValid()&&r.isValid()&&r.isAfter(o)&&o.isBetween(l,c,null,"[]")&&r.isBetween(l,c,null,"[]"))return[o.toDate(),r.toDate()]}},calculateDefaultFocusRange:function(e,t,a,s){const o=void 0!==s&&s.length>0,i=!1===o?a:a.concat(s),r=i[0].date,n=i[i.length-1].date;let l,c;if(!0===o){const t=s[0].date,a=s[s.length-1].date;c=Math.min(t.getTime()+e/2,a.getTime()),l=Math.max(c-e,r.getTime())}else c=n.getTime()+t.asMilliseconds(),l=Math.max(r.getTime(),c-e);return[new Date(l),new Date(c)]},processRecordScoreResults:function(e){const t=[];return(0,n.each)(e,((e,a)=>{t.push({date:new Date(+a),score:e.score})})),t},processMetricPlotResults:b,processForecastResults:S,findChartPointForAnomalyTime:y,processDataForFocusAnomalies:M,findChartPointForScheduledEvent:F,processScheduledEventsForChart:E,getFocusData:function(e,s,i,n,c,d,f,x,v){const y=void 0!==v?l.Dc.toES(v):v;return(0,r.forkJoin)([g.getMetricData(x,s,d,f.min.valueOf(),f.max.valueOf(),i.asMilliseconds(),y),t.results.getAnomalyRecords$([x.job_id],e,0,f.min.valueOf(),f.max.valueOf(),i.expression,v),a.getScheduledEventsByBucket([x.job_id],f.min.valueOf(),f.max.valueOf(),i.asMilliseconds(),1,p.Pk),t.annotations.getAnnotations$({jobIds:[x.job_id],earliestMs:f.min.valueOf(),latestMs:f.max.valueOf(),maxAnnotations:h.b,detectorIndex:s,entities:d}).pipe((0,r.catchError)((e=>(0,r.of)({annotations:{},totalCount:0,error:(0,u.P)(e),success:!1})))),void 0!==n?(()=>{let e;const t=x.analysis_config.detectors[s],a=(0,m.Nc)(t.function);return c||"sum"!==a&&"count"!==a||(e={avg:"sum",max:"sum",min:"sum"}),o.getForecastData(x,s,n,d,f.min.valueOf(),f.max.valueOf(),i.asMilliseconds(),e)})():(0,r.of)(null)]).pipe((0,r.map)((([e,t,a,s,o])=>{const r=null==t?void 0:t.records.sort(((e,t)=>e[p.xL]-t[p.xL])).reverse(),n=null==a?void 0:a.events[x.job_id];let l=b(e.results,c);l=M(l,r,i,c,v),l=E(l,n,i);const u={scheduledEvents:n,anomalyRecords:r,focusChartData:l};var d;return s&&(void 0!==s.error?(u.focusAnnotationError=s.error,u.focusAnnotationData=[]):u.focusAnnotationData=(null!==(d=s.annotations[x.job_id])&&void 0!==d?d:[]).sort(((e,t)=>e.timestamp-t.timestamp)).map(((e,t)=>(e.key=(t+1).toString(),e)))),o&&(u.focusForecastData=S(o.results),u.showForecastCheckbox=u.focusForecastData.length>0),u})))}}}function y(){const{services:e}=(0,b.hk)(),t=(0,b.nK)(),a=(0,g.useMlResultsService)();return(0,s.useMemo)((()=>S(e.uiSettings,t,a)),[])}}}]);