"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRuleModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering a modal to confirm deletion of a rule.
 */

class DeleteRuleModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "deleteRule", () => {
      const {
        ruleIndex,
        deleteRuleAtIndex
      } = this.props;
      deleteRuleAtIndex(ruleIndex);
      this.closeModal();
    });
    (0, _defineProperty2.default)(this, "closeModal", () => {
      this.setState({
        isModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "showModal", () => {
      this.setState({
        isModalVisible: true
      });
    });
    this.state = {
      isModalVisible: false
    };
  }
  render() {
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    let modal;
    if (this.state.isModalVisible) {
      modal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "aria-labelledby": confirmModalTitleId,
        title: _i18n.i18n.translate('xpack.ml.ruleEditor.deleteRuleModal.deleteRuleTitle', {
          defaultMessage: 'Delete rule?'
        }),
        titleProps: {
          id: confirmModalTitleId
        },
        onCancel: this.closeModal,
        onConfirm: this.deleteRule,
        buttonColor: "danger",
        cancelButtonText: _i18n.i18n.translate('xpack.ml.ruleEditor.deleteRuleModal.cancelButtonLabel', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.ml.ruleEditor.deleteRuleModal.deleteButtonLabel', {
          defaultMessage: 'Delete'
        }),
        defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "danger",
      onClick: () => this.showModal(),
      "data-test-subj": "deleteRuleModalLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.deleteRuleModal.deleteRuleLinkText",
      defaultMessage: "Delete rule"
    })), modal);
  }
}
exports.DeleteRuleModal = DeleteRuleModal;
DeleteRuleModal.propTypes = {
  ruleIndex: _propTypes.default.number.isRequired,
  deleteRuleAtIndex: _propTypes.default.func.isRequired
};