"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodePodUsed = exports.nodePodCapacity = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodePodCapacity = exports.nodePodCapacity = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.kubernetes.capacity', {
    defaultMessage: 'Capacity'
  }),
  value: "last_value(kubernetes.node.pod.allocatable.total,  kql='kubernetes.node.pod.allocatable.total: *')",
  format: 'number',
  decimals: 0
};
const nodePodUsed = exports.nodePodUsed = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.kubernetes.used', {
    defaultMessage: 'Used'
  }),
  value: 'unique_count(kubernetes.pod.uid)',
  format: 'number',
  decimals: 0
};