"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  getLayerFeaturesRequestName: true
};
exports.getLayerFeaturesRequestName = void 0;
var _vector_source = require("./vector_source");
Object.keys(_vector_source).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _vector_source[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _vector_source[key];
    }
  });
});
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLayerFeaturesRequestName = layerName => {
  return _i18n.i18n.translate('xpack.maps.vectorSource.featuresRequestName', {
    defaultMessage: 'load layer features ({layerName})',
    values: {
      layerName
    }
  });
};
exports.getLayerFeaturesRequestName = getLayerFeaturesRequestName;