"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowAsLabel = ShowAsLabel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_constants = require("./i18n_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ShowAsLabel(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("dl", null, /*#__PURE__*/_react.default.createElement("dt", null, _i18n_constants.CLUSTER_LABEL), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGeoGrid.clusterDescription",
      defaultMessage: "Group documents into grids with a weighted center for each grid cell."
    }))), /*#__PURE__*/_react.default.createElement("dt", null, _i18n_constants.GRID_LABEL), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGeoGrid.gridDescription",
      defaultMessage: "Group documents into grids."
    }))), /*#__PURE__*/_react.default.createElement("dt", null, _i18n_constants.HEX_LABEL), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGeoGrid.hexDescription",
      defaultMessage: "Group documents into hexagons."
    })), props.isHexDisabled ? /*#__PURE__*/_react.default.createElement("em", null, props.hexDisabledReason) : null)))
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.source.esGeoGrid.showAsLabel",
    defaultMessage: "Show as"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "question",
    color: "subdued"
  })));
}