"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartTrial = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _telemetry_opt_in = require("../../../components/telemetry_opt_in");
var _constants = require("../../../../../common/constants");
var _app_context = require("../../../app_context");
var _telemetry = require("../../../lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StartTrial extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "cancelRef", void 0);
    (0, _defineProperty2.default)(this, "confirmRef", void 0);
    (0, _defineProperty2.default)(this, "state", {
      showConfirmation: false,
      isOptingInToTelemetry: false
    });
    (0, _defineProperty2.default)(this, "onOptInChange", isOptingInToTelemetry => {
      this.setState({
        isOptingInToTelemetry
      });
    });
    (0, _defineProperty2.default)(this, "onStartLicenseTrial", () => {
      const {
        telemetry,
        startLicenseTrial
      } = this.props;
      if (this.state.isOptingInToTelemetry && telemetry) {
        telemetry.telemetryService.setOptIn(true);
      }
      startLicenseTrial();
    });
    (0, _defineProperty2.default)(this, "cancel", () => {
      this.setState({
        showConfirmation: false
      });
    });
  }
  UNSAFE_componentWillMount() {
    this.props.loadTrialStatus();
  }
  acknowledgeModal(docLinks) {
    const {
      showConfirmation,
      isOptingInToTelemetry
    } = this.state;
    const {
      telemetry
    } = this.props;
    if (!showConfirmation) {
      return null;
    }
    const modalTitleId = (0, _eui.htmlIdGenerator)()('modalTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      className: "licManagement__modal",
      onClose: this.cancel,
      "aria-labelledby": modalTitleId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      "data-test-subj": "confirmModalTitleText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalTitle",
      defaultMessage: "Start your free 30-day trial"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "confirmModalBodyText"
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription",
      defaultMessage: "This trial is for the full set of {subscriptionFeaturesLinkText} of the Elastic Stack. You'll get immediate access to:",
      values: {
        subscriptionFeaturesLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants.EXTERNAL_LINKS.SUBSCRIPTIONS,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.subscriptionFeaturesLinkText",
          defaultMessage: "subscription features"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.mashingLearningFeatureTitle",
      defaultMessage: "Machine learning"
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.alertingFeatureTitle",
      defaultMessage: "Alerting"
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.graphCapabilitiesFeatureTitle",
      defaultMessage: "Graph capabilities"
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.dataBaseConnectivityFeatureTitle",
      defaultMessage: "{jdbcStandard} and {odbcStandard} connectivity for {sqlDataBase}",
      values: {
        jdbcStandard: 'JDBC',
        odbcStandard: 'ODBC',
        sqlDataBase: 'SQL'
      }
    }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.securityFeaturesConfigurationDescription",
      defaultMessage: "Advanced security features, such as authentication ({authenticationTypeList}), field- and document-level security, and auditing, require configuration. See the {securityDocumentationLinkText} for instructions.",
      values: {
        authenticationTypeList: 'AD/LDAP, SAML, PKI, SAML/SSO',
        securityDocumentationLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.security,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.securityDocumentationLinkText",
          defaultMessage: "documentation"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.termsAndConditionsDescription",
      defaultMessage: "By starting this trial, you agree that it is subject to these {termsAndConditionsLinkText}.",
      values: {
        termsAndConditionsLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants.EXTERNAL_LINKS.TRIAL_LICENSE,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModalDescription.termsAndConditionsLinkText",
          defaultMessage: "terms and conditions"
        }))
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, (0, _telemetry.shouldShowTelemetryOptIn)(telemetry) && /*#__PURE__*/_react.default.createElement(_telemetry_opt_in.TelemetryOptIn, {
      telemetry: telemetry,
      isStartTrial: true,
      onOptInChange: this.onOptInChange,
      isOptingInToTelemetry: isOptingInToTelemetry
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "licManagement__ieFlex"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "licManagement__ieFlex"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "confirmModalCancelButton",
      onClick: this.cancel,
      buttonRef: this.cancelRef
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "licManagement__ieFlex"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "confirmModalConfirmButton",
      onClick: this.onStartLicenseTrial,
      fill: true,
      buttonRef: this.confirmRef,
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.confirmModal.startTrialButtonLabel",
      defaultMessage: "Start my trial"
    }))))))));
  }
  render() {
    const {
      shouldShowStartTrial
    } = this.props;
    if (!shouldShowStartTrial) {
      return null;
    }
    const description = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.subscriptionFeaturesExperienceDescription",
      defaultMessage: "Experience what machine learning, advanced security, and all our other {subscriptionFeaturesLinkText} have to offer.",
      values: {
        subscriptionFeaturesLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants.EXTERNAL_LINKS.SUBSCRIPTIONS,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.licenseDashboard.startTrial.subscriptionFeaturesLinkText",
          defaultMessage: "subscription features"
        }))
      }
    }));
    const footer = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "startTrialButton",
      onClick: () => this.setState({
        showConfirmation: true
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.startTrial.startTrialButtonLabel",
      defaultMessage: "Start trial"
    }));
    return /*#__PURE__*/_react.default.createElement(_app_context.AppContextConsumer, null, dependencies => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, this.acknowledgeModal(dependencies.docLinks), /*#__PURE__*/_react.default.createElement(_eui.EuiCard
    // @ts-ignore - Known issue from EUI, while they fix their types I've been told that we can just ignore this for now.
    , {
      hasBorder: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.licenseDashboard.startTrialTitle",
        defaultMessage: "Start a 30-day trial"
      }),
      description: description,
      footer: footer
    })));
  }
}
exports.StartTrial = StartTrial;